package com.biz.crm.dms.business.allow.sale.sdk.list.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author sunx
 * @date 2022/1/6
 */
@Data
@ApiModel(value = "AllowSaleListProductPaginationDto", description = "带商品明细的允销清单信息分页查询dto")
public class AllowSaleListProductPaginationDto extends TenantFlagOpDto {
  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;
  /** 商品名称 */
  @ApiModelProperty("商品名称")
  private String productName;
  /** 允销清单类型 */
  @ApiModelProperty(
      "允销清单类型，AllowSaleListTypeEnums，"
          + "TERMINAL(\"terminal\", \"终端\"),\n"
          + "  CUSTOMER(\"customer\", \"客户\"),")
  private String listType;
  /**
   * 允销规则类型
   *
   * @see AllowSaleRuleTypeEnums
   */
  @ApiModelProperty("允销规则类型")
  private String ruleType;
  /** 业务编码，终端编码或客户编码,精准查询 */
  @ApiModelProperty("业务编码，终端编码或客户编码,精准查询")
  private String businessCode;
  /** 业务编码，终端编码或客户编码,模糊查询 */
  @ApiModelProperty("业务编码，终端编码或客户编码,模糊查询")
  private String businessCodeLike;
  /** 终端名称或客户名称 */
  @ApiModelProperty("终端名称或客户名称")
  private String businessName;
  /** 是否需要询价 */
  @ApiModelProperty("是否需要询价，true需要，false不需要")
  private Boolean priceFlag;
  /** 是否需要商品图片信息 */
  @ApiModelProperty("是否需要商品图片信息，true需要，false不需要")
  private Boolean productImageFlag;
  /** 产品层级编码 */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /** 渠道编码 */
  @ApiModelProperty("渠道编码")
  private String channel;

  /** 组织名称 */
  @ApiModelProperty("组织名称")
  private String orgName;
}
