package com.biz.crm.dms.business.allow.sale.sdk.list.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 验证可购商品请求dto
 *
 * @author sunx
 * @date 2021/11/22
 */
@Data
@ApiModel("验证可购商品请求dto")
public class ValidateAllowSaleProductDto {

  /**
   * 允销清单类型，终端或客户
   */
  @ApiModelProperty("允销清单类型，终端或客户，AllowSaleListTypeEnums，terminal-终端，customer-客户")
  private String listType;

  /**
   * 允销规则类型
   *
   * @see AllowSaleRuleTypeEnums
   */
  @ApiModelProperty("允销规则类型")
  private String ruleType;

  /**
   * 终端编码或客户编码
   */
  @ApiModelProperty("终端编码或客户编码")
  private String businessCode;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 待验证的商品编码集合
   */
  @ApiModelProperty("待验证的商品编码集合,不传就是获取所有的")
  private List<String> productCodeList;
}
