package com.biz.crm.dms.business.allow.sale.sdk.list.event;

import com.biz.crm.dms.business.allow.sale.sdk.list.vo.AllowSaleListProductVo;
import java.util.List;

/**
 * 允销清单信息变更事件通知接口
 *
 * @author sunx
 * @date 2021-11-19 15:38:09
 */
public interface AllowSaleListEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(AllowSaleListProductVo vo) {}

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(AllowSaleListProductVo oldVo, AllowSaleListProductVo newVo) {}

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<AllowSaleListProductVo> list) {}
}
