package com.biz.crm.dms.business.allow.sale.sdk.list.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListDmsPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.vo.AllowSaleListDmsVo;
import org.springframework.data.domain.Pageable;

/**
 * 可购清单电商首页分页查询相关接口
 *
 * @author sunx
 * @date 2021/12/6
 */
public interface AllowSaleListDmsVoService {

  /**
   * 分页条件查询
   * 模糊查询
   * @param pageable 分页
   * @param dto 查询参数
   * @return
   */
  Page<AllowSaleListDmsVo> findByConditions(Pageable pageable, AllowSaleListDmsPaginationDto dto);

  /**
   * 分页条件查询
   * 精准搜索
   * @param pageable 分页
   * @param dto 查询参数
   * @return
   */
  Page<AllowSaleListDmsVo> findByConditionsPrecise(Pageable pageable, AllowSaleListDmsPaginationDto dto);
}
