package com.biz.crm.dms.business.allow.sale.sdk.list.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 允销清单信息SDK接口
 *
 * <p>可购清单是确定人货关系的唯一凭证
 *
 * <p>主要属性businessCode+listType+productCode
 *
 * <p>productCode确定货
 *
 * <p>businessCode+listType确定人
 *
 * <p>businessCode 根据业务不同可以是终端、客户、用户等
 *
 * <p>listType 为业务区分，和businessCode业务匹配
 *
 * @author sunx
 * @date 2021-11-19 15:12:37
 */
public interface AllowSaleListVoService {

  /**
   * 获取可购商品编码集合(验证商品是否可购)
   *
   * @param dto 验证可购商品请求dto
   * @return 返回可购的商品编码集合
   */
  List<String> findAllowSaleProductCodes(ValidateAllowSaleProductDto dto);

  /**
   * 获取可购商品编码分页列表(验证商品是否可购)
   *
   * @param dto 参数dto
   * @return 返回可购的商品编码分页列表
   */
  Page<String> findByValidateAllowSaleProductDto(Pageable pageable, ValidateAllowSaleProductDto dto);
}
