package com.biz.crm.dms.business.allow.sale.sdk.list.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.StringUtils;

/**
 * 允销清单信息vo
 *
 * @author sunx
 * @date 2021-11-19 15:12:37
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "允销清单信息Vo")
public class AllowSaleListProductVo extends TenantFlagOpVo {
  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /** 组织名称 */
  @ApiModelProperty("组织名称")
  private String orgName;
  /** 渠道 */
  @ApiModelProperty("渠道")
  private String channel;
  /** 价格组 */
  @ApiModelProperty("价格组")
  private String priceGroup;
  /** 客户编码、终端编码 */
  @ApiModelProperty("客户编码、终端编码")
  private String businessCode;
  /** 客户名称、终端名称 */
  @ApiModelProperty("客户名称、终端名称")
  private String businessName;
  /** 允销清单类型，终端或客户 */
  @ApiModelProperty(
      "允销清单类型，AllowSaleListTypeEnums，"
          + "TERMINAL(\"terminal\", \"终端\"),\n"
          + "  CUSTOMER(\"customer\", \"客户\"),")
  private String listType;
  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;
  /** 商品名称 */
  @ApiModelProperty("商品名称")
  private String productName;
  /** 商品层级编码 */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;
  /** 商品层级 */
  @ApiModelProperty("商品层级")
  private String productLevelName;
  /** 规格 */
  @ApiModelProperty("规格")
  private String spec;
  /** 销售单位 */
  @ApiModelProperty("销售单位")
  private String saleUnit;
  /** 销售价格 */
  @ApiModelProperty("销售价格")
  private BigDecimal price;
  /** 价格编码 */
  @ApiModelProperty("价格编码")
  private String priceCode;
  /** spu编码 */
  @ApiModelProperty("spu编码")
  private String spuCode;
  /** 可购清单行记录唯一码 */
  @ApiModelProperty("可购清单行记录唯一码")
  private String itemKey;
  /** 关联规则编码 */
  @ApiModelProperty("关联规则编码")
  private String relateRuleCode;
  /** 商品信息 */
  @ApiModelProperty("商品信息")
  private ProductVo product;
  /**
   * 询价数据绑定key
   *
   * @return
   */
  public String getPriceKey() {
    return Optional.ofNullable(this.businessCode).orElse(StringUtils.EMPTY)
        + "-"
        + Optional.ofNullable(this.productCode).orElse(StringUtils.EMPTY);
  }
}
