package com.biz.crm.dms.business.allow.sale.sdk.product.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 允销规则关联的可购商品信息vo
 *
 * @author sunx
 * @date 2021-11-19 15:15:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "允销规则关联的可购商品信息Vo")
public class AllowSaleRuleProductVo extends TenantVo {

  /** 允销规则编码 */
  @ApiModelProperty("允销规则编码")
  private String ruleCode;

  /** 关联类型，商品spu或产品层级 */
  @ApiModelProperty("关联类型，商品spu或产品层级")
  private String relateType;

  /** spu编码或商品层级编码 */
  @ApiModelProperty("spu编码或商品层级编码")
  private String relateCode;

  /** spu名称或商品层级名称 */
  @ApiModelProperty("spu名称或商品层级名称")
  private String relateName;
}
