package com.biz.crm.dms.business.allow.sale.sdk.rule.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 允销规则主细信息分页查询dto
 *
 * @author sunx
 * @date 2021-11-19 15:13:18
 */
@Data
@ApiModel(value = "AllowSaleRulePaginationDto", description = "允销规则主细信息分页查询dto")
public class AllowSaleRulePaginationDto extends TenantFlagOpDto {

  /** 允销规则编码 */
  @ApiModelProperty("允销规则编码")
  private String ruleCode;

  /** 允销规则名称 */
  @ApiModelProperty("允销规则名称")
  private String ruleName;

  /** 规则维度 */
  @ApiModelProperty(
      "规则维度,AllowSaleRuleTypeEnums,customer-客户,customer_org-组织(客户),terminal-终端,terminal_org-组织(终端)")
  private String dimensionType;

  /** 创建方式 */
  @ApiModelProperty("创建方式，AllowSaleRuleCreateTypeEnums，default-默认，contract-合同")
  private String createType;
}
