package com.biz.crm.dms.business.allow.sale.sdk.rule.event;

import com.biz.crm.dms.business.allow.sale.sdk.rule.vo.AllowSaleRuleVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import java.util.List;

/**
 * 允销规则主细信息变更事件通知接口
 *
 * @author sunx
 * @date 2021-11-19 15:13:18
 */
public interface AllowSaleRuleEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(AllowSaleRuleVo vo) {}

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(AllowSaleRuleVo oldVo, AllowSaleRuleVo newVo) {}

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<AllowSaleRuleVo> list) {}

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<AllowSaleRuleVo> list) {}

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<AllowSaleRuleVo> list) {}
}
