package com.biz.crm.dms.business.allow.sale.sdk.rule.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.dms.business.allow.sale.sdk.product.vo.AllowSaleRuleProductVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 允销规则主细信息vo
 *
 * @author sunx
 * @date 2021-11-19 15:13:19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "允销规则主细信息Vo")
public class AllowSaleRuleVo extends TenantFlagOpVo {

  /** 允销规则编码 */
  @ApiModelProperty("允销规则编码")
  private String ruleCode;

  /** 允销规则名称 */
  @ApiModelProperty("允销规则名称")
  private String ruleName;

  /** 规则维度 */
  @ApiModelProperty(
      "规则维度,AllowSaleRuleTypeEnums,customer-客户,customer_org-组织(客户),terminal-终端,terminal_org-组织(终端)")
  private String ruleType;

  /** 创建方式 */
  @ApiModelProperty("创建方式，AllowSaleRuleCreateTypeEnums，default-默认，contract-合同")
  private String createType;

  /** 关联数据编码 */
  @ApiModelProperty("关联数据编码")
  private String relateCode;

  /** 关联的组织、客户、终端明细 */
  @ApiModelProperty("关联的组织 客户 终端明细")
  private List<AllowSaleRuleDetailVo> detailList;

  /** 关联的商品明细 */
  @ApiModelProperty("关联的商品明细")
  private List<AllowSaleRuleProductVo> productList;
}
