/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.controller.contract;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractCustomerDto;
import com.biz.crm.dms.business.contract.sdk.service.ContractVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5408\u540c\u7ba1\u7406: ContractVo \u5408\u540c\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/contract/contract"})
public class ContractVoController {
    private static final Logger log = LoggerFactory.getLogger(ContractVoController.class);
    @Autowired(required=false)
    private ContractVoService contractVoService;

    @ApiOperation(value="\u6839\u636e\u4e3b\u952eid\u67e5\u8be2")
    @GetMapping(value={"/findById"})
    public Result<ContractVo> findById(@RequestParam String id) {
        ContractVo result = this.contractVoService.findById(id);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u6839\u636e\u5408\u540c\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"/findDetailsByCode"})
    public Result<ContractVo> findDetailsByCode(@RequestParam String contractCode) {
        ContractVo result = this.contractVoService.findDetailsByCode(contractCode);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u5ba2\u6237-\u5408\u540c\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByContractCustomerDto"})
    public Result<Page<ContractVo>> findByContractCustomerDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="ContractCustomerDto", value="\u5206\u9875Dto") ContractCustomerDto contractCustomerDto) {
        try {
            return Result.ok((Object)this.contractVoService.findByContractCustomerDto(pageable, contractCustomerDto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237-\u5f85\u7b7e\u7f72\u5408\u540c\u6570\u91cf")
    @GetMapping(value={"/findUnsignedCountByCurrentCustomer"})
    public Result<Integer> findUnsignedCountByCurrentCustomer(ContractCustomerDto contractCustomerDto) {
        try {
            Integer count = this.contractVoService.findUnsignedCountByCurrentCustomer(contractCustomerDto);
            return Result.ok((Object)count);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ecf\u9500\u5546\u7f16\u7801\u67e5\u8be2\u751f\u6548\u7684\u5408\u540c\u96c6\u5408")
    @GetMapping(value={"/findEffectiveByCustomerCode"})
    public Result<List<ContractVo>> findEffectiveByCustomerCode(@ApiParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801") String customerCode) {
        try {
            return Result.ok((Object)this.contractVoService.findEffectiveByCustomerCode(customerCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

