/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.repository.contracttemplate;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.contract.local.entity.contracttemplate.ContractTemplate;
import com.biz.crm.dms.business.contract.local.mapper.contracttemplate.ContractTemplateMapper;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplate.ContractTemplateDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ContractTemplateRepository
extends ServiceImpl<ContractTemplateMapper, ContractTemplate> {
    public Page<ContractTemplate> findByConditions(Page<ContractTemplate> pageable, @Param(value="dto") ContractTemplateDto dto) {
        return ((ContractTemplateMapper)this.baseMapper).findByConditions(pageable, dto);
    }

    public ContractTemplate findByContractTemplateCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return (ContractTemplate)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ContractTemplate::getTemplateCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).in(UuidEntity::getId, ids)).update();
    }

    public List<ContractTemplate> findByContractTemplateInIds(String name, String id) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ContractTemplate::getTemplateName, (Object)name)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).ne(StringUtils.isNotEmpty((CharSequence)id), UuidEntity::getId, (Object)id)).list();
    }

    public List<ContractTemplate> findByTemplateCodes(Set<String> templateCodes) {
        if (CollectionUtils.isEmpty(templateCodes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ContractTemplate::getTemplateCode, templateCodes)).list();
    }

    public void updateDelFlagStatusByIdIn(DelFlagStatusEnum delete, List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)delete.getCode())).in(UuidEntity::getId, ids)).update();
    }
}

