/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contract.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.entity.contracthtml.ContractHtmlEntity;
import com.biz.crm.dms.business.contract.local.entity.contracttemplate.ContractTemplate;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractRepository;
import com.biz.crm.dms.business.contract.local.repository.contracthtml.ContractHtmlRepository;
import com.biz.crm.dms.business.contract.local.service.contract.ContractService;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateService;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateVoService;
import com.biz.crm.dms.business.contract.local.utils.contract.ContractUtil;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractDto;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractEventDto;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.dms.business.contract.sdk.enums.ContractCancellationState;
import com.biz.crm.dms.business.contract.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.dms.business.contract.sdk.event.contract.ContractEventListener;
import com.biz.crm.dms.business.contract.sdk.event.contract.ContractManagementEventListener;
import com.biz.crm.dms.business.contract.sdk.event.contractsign.ContractSignEventListener;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.service.ContractVoService;
import com.biz.crm.dms.business.contract.sdk.strategy.ContractSignStrategy;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractElementDataVo;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplate.ContractTemplateVo;
import com.biz.crm.dms.business.interaction.sdk.dto.base.ScopeDto;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeDto;
import com.biz.crm.dms.business.interaction.sdk.enums.NoticeType;
import com.biz.crm.dms.business.interaction.sdk.enums.ScopeType;
import com.biz.crm.dms.business.interaction.sdk.service.notice.NoticeVoService;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractServiceImpl<T extends ContractElementDataVo>
implements ContractService {
    @Autowired(required=false)
    private ContractRepository contractRepository;
    @Autowired(required=false)
    private ContractHtmlRepository contractHtmlRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ContractTemplateVoService contractTemplateVoService;
    @Autowired(required=false)
    private ContractTemplateService contractTemplateService;
    @Autowired(required=false)
    private ContractVoService contractVoService;
    @Autowired(required=false)
    private NoticeVoService noticeVoService;
    @Autowired(required=false)
    private List<ContractEventListener> eventListeners;
    @Autowired(required=false)
    private List<ContractElementRegister> elementRegisters;
    @Autowired(required=false)
    private List<ContractSignStrategy> contractSignStrategies;
    @Autowired(required=false)
    private List<ContractSignEventListener> contractSignEventListeners;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<Contract> findByConditions(Pageable pageable, ContractDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Contract> pageResult = this.contractRepository.findByConditions((Page<Contract>)page, dto);
        return pageResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Contract create(ContractDto contractDto) {
        ContractUtil.validateAdd(contractDto);
        if (StringUtils.isNotBlank((CharSequence)contractDto.getContractCode())) {
            ContractVo contractVo = this.contractVoService.findDetailsByCode(contractDto.getContractCode());
            Validate.isTrue((boolean)Objects.isNull(contractVo), (String)"\u5408\u540c\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        ContractTemplateVo contractTemplateVo = this.validateContractTemplate(contractDto);
        Contract entity = this.transformCreate(contractDto);
        this.saveContractElementData(contractDto, contractTemplateVo);
        this.contractRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            ContractVo contractVo = (ContractVo)this.nebulaToolkitService.copyObjectByBlankList((Object)contractDto, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(eventListener -> eventListener.onCreate(contractVo));
        }
        this.saveHtml(contractDto.getHtmlStr(), entity.getContractCode());
        contractDto.setId(entity.getId());
        ContractEventDto contractEventDto = new ContractEventDto();
        contractEventDto.setOnlyKey(entity.getId());
        contractEventDto.setNewest((Object)contractDto);
        SerializableBiConsumer & Serializable onCreate = ContractManagementEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)contractEventDto, ContractManagementEventListener.class, (SerializableBiConsumer)onCreate);
        String commitProcess = this.commitProcess(contractDto);
        entity.setProcessNumber(commitProcess);
        this.contractRepository.updateById((Object)entity);
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Contract update(ContractDto contractDto) {
        ContractUtil.validateEdit(contractDto);
        ContractTemplateVo contractTemplateVo = this.validateContractTemplate(contractDto);
        this.updateContractElementData(contractDto, contractTemplateVo);
        ContractVo contractOld = this.contractVoService.findById(contractDto.getId());
        Contract entity = this.transformUpdate(contractDto, contractOld);
        this.contractRepository.updateById((Object)entity);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            ContractVo newVo = (ContractVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(eventListener -> eventListener.onUpdate(contractOld, newVo));
        }
        this.contractHtmlRepository.updateByContractCode(contractDto.getHtmlStr(), contractDto.getContractCode());
        ContractEventDto contractEventDto = new ContractEventDto();
        contractEventDto.setOnlyKey(entity.getId());
        contractEventDto.setNewest((Object)contractDto);
        contractEventDto.setOriginal((Object)contractOld);
        SerializableBiConsumer & Serializable onUpdate = ContractManagementEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)contractEventDto, ContractManagementEventListener.class, (SerializableBiConsumer)onUpdate);
        String commitProcess = this.commitProcess(contractDto);
        entity.setProcessNumber(commitProcess);
        entity.setProcessRemark(contractDto.getProcessRemark());
        this.contractRepository.updateById((Object)entity);
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = this.contractRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.contractRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, Contract.class, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(listener -> listener.onEnable(voList));
        }
        for (Contract contract : entities) {
            ContractEventDto productSingleEventDto = new ContractEventDto();
            productSingleEventDto.setOnlyKey(contract.getId());
            JSONObject jsonObjectOld = new JSONObject();
            JSONObject jsonObjectNew = new JSONObject();
            jsonObjectOld.put("enableStatus", (Object)contract.getEnableStatus());
            jsonObjectNew.put("enableStatus", (Object)EnableStatusEnum.ENABLE.getCode());
            productSingleEventDto.setOriginal((Object)jsonObjectOld);
            productSingleEventDto.setNewest((Object)jsonObjectNew);
            SerializableBiConsumer & Serializable onEnable = ContractManagementEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ContractManagementEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.contractRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.contractRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, Contract.class, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(listener -> listener.onDisable(voList));
        }
        for (Contract contract : entities) {
            ContractEventDto productSingleEventDto = new ContractEventDto();
            productSingleEventDto.setOnlyKey(contract.getId());
            JSONObject jsonObjectOld = new JSONObject();
            JSONObject jsonObjectNew = new JSONObject();
            jsonObjectOld.put("enableStatus", (Object)contract.getEnableStatus());
            jsonObjectNew.put("enableStatus", (Object)EnableStatusEnum.DISABLE.getCode());
            productSingleEventDto.setOriginal((Object)jsonObjectOld);
            productSingleEventDto.setNewest((Object)jsonObjectNew);
            SerializableBiConsumer & Serializable onDisable = ContractManagementEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ContractManagementEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    @Override
    @Transactional
    public void signContract(String contractCode) {
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        Validate.notBlank((CharSequence)loginUserDetails.getCustomerCode(), (String)"\u4e3a\u83b7\u53d6\u5230\u767b\u9646\u4eba\u4fe1\u606f\uff01", (Object[])new Object[0]);
        ContractVo contractVo = this.contractVoService.findDetailsByCode(contractCode);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(this.contractSignStrategies), (String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u7b7e\u7ea6\u65b9\u5f0f\u5b9e\u73b0,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.contractSignStrategies.forEach(s -> {
            if (s.getContractSignTypeCode().equals(contractVo.getContractSignType())) {
                s.onRequestContractSign(contractVo);
            }
        });
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String nowDate = format.format(new Date());
        Validate.isTrue((nowDate.compareTo(contractVo.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u5408\u540c\u6709\u6548\u671f\u5df2\u8fc7\u4e0d\u80fd\u7b7e\u7ea6\uff01", (Object[])new Object[0]);
        String effectiveStatus = nowDate.compareTo(contractVo.getStartTime()) >= 0 ? EffectiveStatusEnum.EFFECTIVE_ACTIVE.getDictCode() : EffectiveStatusEnum.EFFECTIVE_STAY.getDictCode();
        this.contractRepository.updateSignStateById(ActApproveStatusExtendEnum.SIGN_CONTRACT.getKey(), effectiveStatus, contractCode);
        if (CollectionUtils.isNotEmpty(this.contractSignEventListeners)) {
            contractVo.setEffectiveStatus(effectiveStatus);
            this.contractSignEventListeners.forEach(signEventListener -> signEventListener.onSignContract(contractVo));
        }
    }

    @Override
    @Transactional
    public void cancellation(String contractCode) {
        ContractVo contractVo = this.contractVoService.findDetailsByCode(contractCode);
        Validate.notNull((Object)contractVo, (String)"\u5408\u540c\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Integer cancellationState = contractVo.getCancellationState();
        this.contractRepository.updateCancellationStateByContractCode(ContractCancellationState.NOT_CANCELLATION.getKey(), contractCode);
        contractVo.setCancellationState(ContractCancellationState.NOT_CANCELLATION.getKey());
        if (CollectionUtils.isNotEmpty(this.contractSignEventListeners)) {
            this.contractSignEventListeners.forEach(signEventListener -> signEventListener.onCancellation(contractVo));
        }
        ContractEventDto productSingleEventDto = new ContractEventDto();
        productSingleEventDto.setOnlyKey(contractVo.getId());
        JSONObject jsonObjectOld = new JSONObject();
        JSONObject jsonObjectNew = new JSONObject();
        jsonObjectOld.put("cancellationState", (Object)cancellationState);
        jsonObjectNew.put("cancellationState", (Object)ContractCancellationState.NOT_CANCELLATION.getKey());
        productSingleEventDto.setOriginal((Object)jsonObjectOld);
        productSingleEventDto.setNewest((Object)jsonObjectNew);
        SerializableBiConsumer & Serializable onCancellation = ContractManagementEventListener::onCancellation;
        this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ContractManagementEventListener.class, (SerializableBiConsumer)onCancellation);
    }

    @Override
    public void handlePush(String contractCode) {
        ContractVo contractVo = this.contractVoService.findDetailsByCode(contractCode);
        Validate.notNull((Object)contractVo, (String)"\u5408\u540c\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((ActApproveStatusExtendEnum.PUSH_NO_CONTRACT.getKey().equals(contractVo.getContractStatus()) || ActApproveStatusExtendEnum.PUSH_FAIL_CONTRACT.getKey().equals(contractVo.getContractStatus()) ? 1 : 0) != 0, (String)"\u5408\u540c\u4e0d\u662f\u53ef\u63a8\u9001\u72b6\u6001\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)Integer.valueOf(BooleanEnum.FALSE.getNumStr()).equals(contractVo.getCancellationState()), (String)"\u5408\u540c\u5df2\u4f5c\u5e9f", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(contractVo.getEnableStatus()), (String)"\u5408\u540c\u5df2\u7981\u7528", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(contractVo.getDelFlag()), (String)"\u5408\u540c\u5df2\u5220\u9664", (Object[])new Object[0]);
        Validate.isTrue((!EffectiveStatusEnum.EFFECTIVE_LOSE.getKey().equals(contractVo.getEffectiveStatus()) ? 1 : 0) != 0, (String)"\u5408\u540c\u5df2\u5931\u6548", (Object[])new Object[0]);
        this.contractRepository.updateContractStatusByContractCode(ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getKey(), contractCode);
    }

    @Override
    @Transactional
    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u5408\u540c\u8fc7\u671f")
    public void expire() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(6, calendar.get(6) - 1);
        List<Contract> contractList = this.contractRepository.findByEndTime(format.format(calendar.getTime()));
        if (CollectionUtils.isNotEmpty(contractList)) {
            contractList.forEach(contract -> contract.setEffectiveStatus(EffectiveStatusEnum.EFFECTIVE_LOSE.getDictCode()));
            this.contractRepository.updateBatchById(contractList);
        }
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(contractList, Contract.class, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(listener -> listener.onMaturity(voList));
        }
    }

    @Override
    @Transactional
    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u5408\u540c\u751f\u6548")
    public void effective() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(6, calendar.get(6));
        List<Contract> contractList = this.contractRepository.findByStartTime(format.format(calendar.getTime()));
        if (CollectionUtils.isNotEmpty(contractList)) {
            contractList.forEach(contract -> contract.setEffectiveStatus(EffectiveStatusEnum.EFFECTIVE_ACTIVE.getDictCode()));
            this.contractRepository.updateBatchById(contractList);
            if (CollectionUtils.isNotEmpty(this.eventListeners)) {
                List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(contractList, Contract.class, ContractVo.class, HashSet.class, ArrayList.class, new String[0]);
                this.eventListeners.forEach(listener -> listener.onEffective(voList));
            }
        }
    }

    @Override
    @Transactional
    @DynamicTaskService(cornExpression="0 0 1 * * ?", taskDesc="\u5408\u540c\u5230\u671f\u63d0\u9192(\u5b9a\u65f6\u4efb\u52a1)")
    public void expireEminder() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String today = format.format(new Date());
        List<Contract> contracts = this.contractRepository.findByExpireEminderDate(today);
        this.transformContractToNoticeDto(contracts);
    }

    private ContractTemplateVo validateContractTemplate(ContractDto contractDto) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(this.elementRegisters), (String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u6ce8\u518c\u8981\u7d20,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ContractTemplateVo contractTemplateVo = this.contractTemplateVoService.findDetailsByCode(contractDto.getTemplateCode());
        Validate.notNull((Object)contractTemplateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6a21\u677f", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)contractTemplateVo.getTemplateElements()), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6a21\u677f\u8981\u7d20\u5217\u8868", (Object[])new Object[0]);
        return contractTemplateVo;
    }

    private void updateContractElementData(ContractDto contractDto, ContractTemplateVo contractTemplateVo) {
        Map data = contractDto.getElementDataMap();
        contractTemplateVo.getTemplateElements().forEach(templateElement -> {
            List collect = this.elementRegisters.stream().filter(elementRegister -> elementRegister.getContractElementCode().equals(templateElement.getElementCode())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(collect), (String)"\u8981\u7d20\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            ContractElementRegister contractElementRegister = (ContractElementRegister)collect.get(0);
            JSONObject jsonObject = (JSONObject)data.get(contractElementRegister.getContractElementCode());
            Validate.notNull((Object)jsonObject, (String)"\u8981\u7d20\u540d\u79f0\u3010%s\u3011\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[]{contractElementRegister.getContractElementName()});
            Class elementClass = contractElementRegister.getContractElementClass();
            contractElementRegister.onRequestContractUpdate(contractDto.getContractCode(), (ContractElementDataVo)JSON.parseObject((String)jsonObject.toJSONString(), (Class)elementClass), templateElement.getIndexCode());
        });
    }

    private void saveContractElementData(ContractDto contractDto, ContractTemplateVo contractTemplateVo) {
        Map data = contractDto.getElementDataMap();
        contractTemplateVo.getTemplateElements().forEach(templateElement -> {
            List collect = this.elementRegisters.stream().filter(elementRegister -> elementRegister.getContractElementCode().equals(templateElement.getElementCode())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(collect), (String)"\u8981\u7d20\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            ContractElementRegister contractElementRegister = (ContractElementRegister)collect.get(0);
            JSONObject jsonObject = (JSONObject)data.get(contractElementRegister.getContractElementCode());
            Validate.isTrue((boolean)Objects.nonNull(jsonObject), (String)("\u5408\u540c\u4e2d:" + templateElement.getElementName() + "\u6570\u636e\u4e3a\u7a7a"), (Object[])new Object[0]);
            Class elementClass = contractElementRegister.getContractElementClass();
            contractElementRegister.onRequestContractCreate(contractDto.getContractCode(), (ContractElementDataVo)JSON.parseObject((String)jsonObject.toJSONString(), (Class)elementClass), templateElement.getIndexCode());
        });
    }

    private void transformContractToNoticeDto(List<Contract> contracts) {
        Map<String, List<Contract>> listMap;
        Set<String> templateCodes;
        List<ContractTemplate> contractTemplates;
        if (CollectionUtils.isNotEmpty(contracts) && CollectionUtils.isNotEmpty(contractTemplates = this.contractTemplateService.findByTemplateCodes(templateCodes = (listMap = contracts.stream().collect(Collectors.groupingBy(Contract::getTemplateCode))).keySet()))) {
            Map<String, ContractTemplate> contractTemplateMap = contractTemplates.stream().collect(Collectors.toMap(ContractTemplate::getTemplateCode, t -> t, (key1, key2) -> key2));
            ArrayList noticeDtos = new ArrayList();
            Date date = new Date();
            listMap.forEach((k, v) -> {
                ContractTemplate contractTemplate = (ContractTemplate)((Object)((Object)contractTemplateMap.get(k)));
                if (Objects.nonNull((Object)contractTemplate)) {
                    Integer effectiveDay = contractTemplate.getEffectiveDay();
                    v.forEach(contract -> {
                        NoticeDto noticeDto = new NoticeDto();
                        noticeDto.setTitle("\u5408\u540c\u8fc7\u671f\u63d0\u9192");
                        noticeDto.setType(NoticeType.INFORM.getKey());
                        noticeDto.setStartTime(this.getDate(date, 0));
                        noticeDto.setEndTime(this.getDate(date, -effectiveDay.intValue()));
                        noticeDto.setIndexPopup(contractTemplate.getIndexPopup());
                        noticeDto.setPopupType(contractTemplate.getPopupType());
                        noticeDto.setContent(contract.getContractCode() + contractTemplate.getContext());
                        ScopeDto scopeDto = new ScopeDto();
                        scopeDto.setScopeCode(contract.getCusCode());
                        scopeDto.setScopeType(ScopeType.CUSTOMER.name());
                        scopeDto.setContainFlag(Boolean.valueOf(true));
                        noticeDto.setScopeList(Collections.singletonList(scopeDto));
                        noticeDtos.add(noticeDto);
                    });
                }
            });
            this.noticeVoService.create(noticeDtos);
        }
    }

    private Date getDate(Date date, int num) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, calendar.get(6) - num);
        if (num >= 0) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        } else {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
        }
        return calendar.getTime();
    }

    private Contract transformCreate(ContractDto contractDto) {
        Contract entity = (Contract)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractDto, Contract.class, HashSet.class, ArrayList.class, new String[0]));
        if (StringUtils.isBlank((CharSequence)entity.getContractCode())) {
            entity.setContractCode((String)this.generateCodeService.generateCode("XSHT", 1).get(0));
        } else {
            Validate.isTrue((entity.getContractCode().length() < 128 ? 1 : 0) != 0, (String)"\u5408\u540c\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7128", (Object[])new Object[0]);
        }
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setCancellationState(Integer.valueOf(BooleanEnum.FALSE.getNumStr()));
        entity.setContractStatus(ActApproveStatusEnum.APPROVING.getCode());
        entity.setEffectiveStatus(EffectiveStatusEnum.EFFECTIVE_STAY.getDictCode());
        contractDto.setContractCode(entity.getContractCode());
        ContractUtil.getExpireEminderDate(entity);
        return entity;
    }

    private Contract transformUpdate(ContractDto contractDto, ContractVo contractOld) {
        Contract entity = (Contract)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contractDto, Contract.class, HashSet.class, ArrayList.class, new String[0]));
        Validate.isTrue((boolean)Objects.nonNull(contractOld), (String)"\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        entity.setTenantCode(contractOld.getTenantCode());
        entity.setDelFlag(contractOld.getDelFlag());
        entity.setEnableStatus(contractOld.getEnableStatus());
        entity.setCancellationState(contractOld.getCancellationState());
        entity.setContractStatus(ActApproveStatusEnum.APPROVING.getCode());
        ContractUtil.getExpireEminderDate(entity);
        return entity;
    }

    private String commitProcess(ContractDto contractDto) {
        StartProcessDto activitiBusinessVo = new StartProcessDto();
        activitiBusinessVo.setProcessKey(contractDto.getProcessKey());
        activitiBusinessVo.setBusinessId(contractDto.getId());
        activitiBusinessVo.setBusinessNo(contractDto.getContractCode());
        activitiBusinessVo.setRemark(contractDto.getProcessRemark());
        activitiBusinessVo.setAttachmentVos(contractDto.getAttachmentVos());
        activitiBusinessVo.setMenuCode(contractDto.getCompetenceCode());
        activitiBusinessVo.setFormType("contract");
        activitiBusinessVo.setProcessTitle(contractDto.getProcessTitle());
        HashMap map = Maps.newHashMap();
        map.put("customer_code", contractDto.getCusCode());
        activitiBusinessVo.setVariables((Map)map);
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)activitiBusinessVo, ProcessListener.class, (SerializableBiConsumer)sf);
        if (StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId())) {
            return response.getProcessInstanceId();
        }
        throw new RuntimeException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01");
    }

    private void saveHtml(String htmlStr, String contractCode) {
        if (StringUtils.isNotBlank((CharSequence)htmlStr) && StringUtils.isNotBlank((CharSequence)contractCode)) {
            ContractHtmlEntity contractHtmlEntity = new ContractHtmlEntity();
            contractHtmlEntity.setHtmlStr(htmlStr);
            contractHtmlEntity.setContractCode(contractCode);
            this.contractHtmlRepository.save((Object)contractHtmlEntity);
        }
    }
}

