/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contract.observer;

import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.repository.contract.ContractRepository;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ContractProcessCallBackListener
implements CallBackListener {
    @Autowired(required=false)
    private ContractRepository contractRepository;

    @Transactional
    public void onCallBack(CallBackDto dto) {
        if (!dto.getFormType().equals("contract")) {
            return;
        }
        Contract contract = this.contractRepository.findByContractProcessNo(dto.getProcessNo());
        if (ObjectUtils.isEmpty((Object)((Object)contract))) {
            return;
        }
        Validate.isTrue((boolean)contract.getContractStatus().equals(ActApproveStatusEnum.APPROVING.getCode()), (String)"\u6b64\u8ba2\u5355\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        contract.setContractStatus(String.valueOf(dto.getProcessState()));
        if (ActApproveStatusEnum.APPROVED.getCode().equals(String.valueOf(dto.getProcessState()))) {
            contract.setContractStatus(ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getKey());
        }
        if (ActApproveStatusEnum.INTERRUPT.getCode().equals(String.valueOf(dto.getProcessState()))) {
            contract.setContractStatus(ActApproveStatusEnum.CREATE.getCode());
            contract.setProcessNumber(null);
            contract.setProcessRemark(null);
        }
        this.contractRepository.updateById((Object)contract);
    }
}

