/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contractaddresscontact.internal;

import com.biz.crm.dms.business.contract.local.entity.contractaddresscontact.ContractAddressContact;
import com.biz.crm.dms.business.contract.local.repository.contractaddresscontact.ContractAddressContactRepository;
import com.biz.crm.dms.business.contract.local.service.contractaddresscontact.ContractAddressContactService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractAddressContactDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractAddressContactService")
public class ContractAddressContactServiceImpl
implements ContractAddressContactService {
    private static final Logger log = LoggerFactory.getLogger(ContractAddressContactServiceImpl.class);
    @Autowired
    private ContractAddressContactRepository contractAddressContactRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ContractAddressContact findByContractCode(String contractCode) {
        if (StringUtils.isBlank((CharSequence)contractCode)) {
            return null;
        }
        return this.contractAddressContactRepository.findByContractCode(contractCode);
    }

    @Override
    public ContractAddressContact create(String contractCode, ContractAddressContactDataVo vo, Integer indexCode) {
        this.validateCreateOrUpdate(contractCode, vo);
        ContractAddressContact addressContact = (ContractAddressContact)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, ContractAddressContact.class, HashSet.class, ArrayList.class, new String[0]));
        addressContact.setContractCode(contractCode);
        this.contractAddressContactRepository.save((Object)addressContact);
        return addressContact;
    }

    @Override
    public ContractAddressContact update(String contractCode, ContractAddressContactDataVo vo, Integer indexCode) {
        this.validateCreateOrUpdate(contractCode, vo);
        this.contractAddressContactRepository.deleteByContractCode(contractCode);
        ContractAddressContact addressContact = (ContractAddressContact)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, ContractAddressContact.class, HashSet.class, ArrayList.class, new String[0]));
        addressContact.setContractCode(contractCode);
        this.contractAddressContactRepository.save((Object)addressContact);
        return addressContact;
    }

    private void validateCreateOrUpdate(String contractCode, ContractAddressContactDataVo vo) {
        Validate.notBlank((CharSequence)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)vo, (String)"\u5408\u540c\u5730\u5740\u8054\u7cfb\u4eba\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vo.getSupplierLegalAddress(), (String)"\u4f9b\u65b9\u6cd5\u5b9a\u5730\u5740\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vo.getSupplierContact(), (String)"\u4f9b\u65b9\u8054\u7cfb\u4eba\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vo.getBuyerLegalAddress(), (String)"\u9700\u65b9\u6cd5\u5b9a\u5730\u5740\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vo.getBuyerContact(), (String)"\u9700\u65b9\u8054\u7cfb\u4eba\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

