/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contractfiles.internal;

import com.biz.crm.dms.business.contract.local.entity.contractfiles.ContractFiles;
import com.biz.crm.dms.business.contract.local.repository.contractfiles.ContractFilesRepository;
import com.biz.crm.dms.business.contract.local.service.contractfiles.ContractFilesDataVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractFilesDataVo;
import com.biz.crm.dms.business.contract.sdk.vo.contractfiles.ContractFilesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractFilesDataVoServiceImpl
implements ContractFilesDataVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractFilesDataVoServiceImpl.class);
    @Autowired(required=false)
    private ContractFilesRepository contractFilesRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ContractFilesDataVo findByContractCode(String contractCode) {
        List<ContractFiles> contractFiles = this.contractFilesRepository.findByContractCode(contractCode);
        if (CollectionUtils.isEmpty(contractFiles)) {
            return null;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(contractFiles, ContractFiles.class, ContractFilesVo.class, HashSet.class, ArrayList.class, new String[0]);
        ContractFilesDataVo vo = new ContractFilesDataVo();
        vo.setContractFilesVos(voList);
        return vo;
    }

    @Override
    @Transactional
    public ContractFilesDataVo createContractFilesElement(String contractCode, ContractFilesDataVo contractFilesDateVo, Integer indexCode) {
        this.ValidateSaveOrUpdate(contractCode, contractFilesDateVo);
        List contractFilesVos = contractFilesDateVo.getContractFilesVos();
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)contractFilesVos, ContractFilesVo.class, ContractFiles.class, HashSet.class, ArrayList.class, new String[0]);
        this.contractFilesRepository.saveBatch(voList);
        return contractFilesDateVo;
    }

    @Override
    @Transactional
    public ContractFilesDataVo updateContractFilesElement(String contractCode, ContractFilesDataVo contractFilesDateVo, Integer indexCode) {
        this.ValidateSaveOrUpdate(contractCode, contractFilesDateVo);
        this.contractFilesRepository.deleteByContractCode(contractCode);
        List contractFilesVos = contractFilesDateVo.getContractFilesVos();
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)contractFilesVos, ContractFilesVo.class, ContractFiles.class, HashSet.class, ArrayList.class, new String[0]);
        voList.forEach(contractFiles -> contractFiles.setId(null));
        this.contractFilesRepository.saveBatch(voList);
        return contractFilesDateVo;
    }

    private void ValidateSaveOrUpdate(String contractCode, ContractFilesDataVo contractFilesDateVo) {
        Validate.notBlank((CharSequence)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)contractFilesDateVo, (String)"\u5408\u540c\u9644\u4ef6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)contractFilesDateVo.getContractFilesVos()), (String)"\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List contractFilesVos = contractFilesDateVo.getContractFilesVos();
        contractFilesVos.forEach(contractFilesVo -> {
            Validate.notBlank((CharSequence)contractFilesVo.getFileName(), (String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contractFilesVo.getObjectName(), (String)"\u6587\u4ef6\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contractFilesVo.getUrl(), (String)"\u6587\u4ef6\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contractFilesVo.getUrlPath(), (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contractFilesVo.getUrlPathPrefix(), (String)"\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            contractFilesVo.setContractCode(contractCode);
        });
    }
}

