/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contractfreight.internal;

import com.biz.crm.dms.business.contract.local.entity.contractfreight.ContractFreight;
import com.biz.crm.dms.business.contract.local.repository.contractfreight.ContractFreightRepository;
import com.biz.crm.dms.business.contract.local.service.contractfreight.ContractFreightService;
import com.biz.crm.dms.business.contract.sdk.enums.DistributionEnum;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractFreightDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractFreightService")
public class ContractFreightServiceImpl
implements ContractFreightService {
    private static final Logger log = LoggerFactory.getLogger(ContractFreightServiceImpl.class);
    @Autowired
    private ContractFreightRepository contractFreightRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ContractFreight findByContractCode(String contractCode) {
        if (StringUtils.isBlank((CharSequence)contractCode)) {
            return null;
        }
        return this.contractFreightRepository.findByContractCode(contractCode);
    }

    @Override
    public ContractFreight create(String contractCode, ContractFreightDataVo vo, Integer indexCode) {
        this.validateCreateOrUpdate(contractCode, vo);
        ContractFreight addressContact = (ContractFreight)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, ContractFreight.class, HashSet.class, ArrayList.class, new String[0]));
        addressContact.setContractCode(contractCode);
        this.contractFreightRepository.save((Object)addressContact);
        return addressContact;
    }

    @Override
    public ContractFreight update(String contractCode, ContractFreightDataVo vo, Integer indexCode) {
        this.validateCreateOrUpdate(contractCode, vo);
        this.contractFreightRepository.deleteByContractCode(contractCode);
        ContractFreight addressContact = (ContractFreight)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, ContractFreight.class, HashSet.class, ArrayList.class, new String[0]));
        addressContact.setContractCode(contractCode);
        this.contractFreightRepository.updateById((Object)addressContact);
        return addressContact;
    }

    private void validateCreateOrUpdate(String contractCode, ContractFreightDataVo vo) {
        Validate.notBlank((CharSequence)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)vo, (String)"\u5408\u540c\u8fd0\u8d39\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vo.getDistributionType(), (String)"\u914d\u9001\u65b9\u5f0f\u4e3a\u7a7a", (Object[])new Object[0]);
        if (DistributionEnum.DELIVERY.getDictCode().equals(vo.getDistributionType())) {
            Validate.notBlank((CharSequence)vo.getSettlementType(), (String)"\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(vo.getFreightAmount()) && vo.getFreightAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8fd0\u8d39\u91d1\u989d\u9519\u8bef", (Object[])new Object[0]);
        }
    }
}

