/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contracttemplate.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.contract.local.entity.contracttemplate.ContractTemplate;
import com.biz.crm.dms.business.contract.local.repository.contracttemplate.ContractTemplateRepository;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateService;
import com.biz.crm.dms.business.contract.local.service.contracttemplateelement.ContractTemplateElementVoService;
import com.biz.crm.dms.business.contract.local.utils.contracttemplate.ContractTemplateUtil;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplate.ContractTemplateDto;
import com.biz.crm.dms.business.contract.sdk.event.contracttemplate.ContractTemplateEventListener;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.service.ContractVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplate.ContractTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractTemplateServiceImpl
implements ContractTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ContractTemplateServiceImpl.class);
    @Autowired(required=false)
    private ContractTemplateRepository contractTemplateRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ContractTemplateElementVoService contractTemplateElementVoService;
    @Autowired(required=false)
    private ContractVoService contractVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ContractTemplateEventListener> eventListeners;
    @Autowired(required=false)
    private List<ContractElementRegister> elementRegisters;

    @Override
    public Page<ContractTemplate> findByConditions(Pageable pageable, ContractTemplateDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ContractTemplate> pageResult = this.contractTemplateRepository.findByConditions((Page<ContractTemplate>)page, dto);
        return pageResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ContractTemplate create(ContractTemplateDto dto) {
        List modelDtoList = dto.getTemplateElements();
        ContractTemplateUtil.validateAdd(dto);
        this.validateName(dto.getTemplateName(), null);
        dto.getTemplateElements().forEach(s -> this.validateContractElement(s.getElementCode()));
        String templateCode = (String)this.generateCodeService.generateCode("HTMB", 1).get(0);
        ContractTemplate contractTemplate = this.contractTemplateRepository.findByContractTemplateCode(templateCode);
        Validate.isTrue((boolean)Objects.isNull((Object)contractTemplate), (String)"\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
        dto.setTemplateCode(templateCode);
        ContractTemplate entity = (ContractTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ContractTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setId(null);
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.contractTemplateRepository.save((Object)entity);
        this.contractTemplateElementVoService.saveBatch(modelDtoList, dto.getTemplateCode());
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            ContractTemplateVo vo = (ContractTemplateVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ContractTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(eventListener -> eventListener.onCreate(vo));
        }
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ContractTemplate update(ContractTemplateDto dto) {
        List modelDtoList = dto.getTemplateElements();
        ContractTemplateUtil.validateEdit(dto);
        this.validateName(dto.getTemplateName(), dto.getId());
        dto.getTemplateElements().forEach(s -> this.validateContractElement(s.getElementCode()));
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)this.contractVoService.findByTemplateCode(Collections.singletonList(dto.getTemplateCode()))), (String)"\u5408\u540c\u6a21\u677f\u5df2\u5b58\u5728\u5408\u540c,\u4e0d\u80fd\u4fee\u6539\u5408\u540c\u6a21\u677f", (Object[])new Object[0]);
        ContractTemplate entity = (ContractTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ContractTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        this.contractTemplateRepository.updateById((Object)entity);
        this.contractTemplateElementVoService.updateBatch(modelDtoList, dto.getTemplateCode());
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            ContractTemplateVo oldVo = (ContractTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ContractTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
            ContractTemplateVo newVo = (ContractTemplateVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ContractTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(eventListener -> eventListener.onUpdate(oldVo, newVo));
        }
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = this.contractTemplateRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.contractTemplateRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, ContractTemplate.class, ContractTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.contractTemplateRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.contractTemplateRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, ContractTemplate.class, ContractTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    @Override
    public List<ContractTemplate> findByTemplateCodes(Set<String> templateCodes) {
        return this.contractTemplateRepository.findByTemplateCodes(templateCodes);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u5220\u9664\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = this.contractTemplateRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List templateCodes = entities.stream().map(ContractTemplate::getTemplateCode).collect(Collectors.toList());
        List contractVos = this.contractVoService.findByTemplateCode(templateCodes);
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)contractVos), (String)"\u6a21\u677f\u5df2\u751f\u6210\u5408\u540c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        this.contractTemplateRepository.updateDelFlagStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, ContractTemplate.class, ContractTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.eventListeners.forEach(listener -> listener.onDelete(voList));
        }
    }

    private void validateName(String name, String id) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        List<ContractTemplate> entities = this.contractTemplateRepository.findByContractTemplateInIds(name, id);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(entities), (String)"\u6a21\u677f\u540d\u79f0\u3010%s\u3011\u91cd\u590d", (Object[])new Object[]{name});
    }

    private void validateContractElement(String contractElementCode) {
        Validate.notBlank((CharSequence)contractElementCode, (String)"\u5408\u540c\u8981\u7d20\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(this.elementRegisters), (String)"\u7cfb\u7edf\u6ca1\u6709\u6a21\u677f\u6ce8\u518c", (Object[])new Object[0]);
        List contractElements = this.elementRegisters.stream().filter(elementRegister -> contractElementCode.equals(elementRegister.getContractElementCode())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(contractElements), (String)"\u5408\u540c\u8981\u7d20\u6a21\u677f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
    }
}

