/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.service.contracttemplate.internal;

import com.biz.crm.dms.business.contract.local.entity.contracttemplate.ContractTemplate;
import com.biz.crm.dms.business.contract.local.repository.contracttemplate.ContractTemplateRepository;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateVoService;
import com.biz.crm.dms.business.contract.local.service.contracttemplateelement.ContractTemplateElementVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplate.ContractTemplateVo;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplateelement.ContractTemplateElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ContractTemplateVoServiceImpl
implements ContractTemplateVoService {
    private static final Logger log = LoggerFactory.getLogger(ContractTemplateVoServiceImpl.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ContractTemplateElementVoService contractTemplateElementVoService;
    @Autowired(required=false)
    private ContractTemplateRepository contractTemplateRepository;

    @Override
    public ContractTemplateVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ContractTemplate entity = (ContractTemplate)((Object)this.contractTemplateRepository.getById((Serializable)((Object)id)));
        if (entity == null) {
            return null;
        }
        ContractTemplateVo templateVo = (ContractTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ContractTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<ContractTemplateElementVo> templateElementList = this.contractTemplateElementVoService.findByContractTemplateCode(templateVo.getTemplateCode());
        if (CollectionUtils.isNotEmpty(templateElementList)) {
            templateVo.setTemplateElements(templateElementList);
        }
        return templateVo;
    }

    @Override
    public ContractTemplateVo findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ContractTemplate entity = this.contractTemplateRepository.findByContractTemplateCode(code);
        if (entity == null) {
            return null;
        }
        ContractTemplateVo templateVo = (ContractTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ContractTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<ContractTemplateElementVo> templateElementList = this.contractTemplateElementVoService.findByContractTemplateCode(templateVo.getTemplateCode());
        if (CollectionUtils.isNotEmpty(templateElementList)) {
            Map<String, List<ContractTemplateElementVo>> collect = templateElementList.stream().collect(Collectors.groupingBy(ContractTemplateElementVo::getElementCode));
            ArrayList list = new ArrayList();
            collect.forEach((k, v) -> list.add((ContractTemplateElementVo)v.get(0)));
            templateVo.setTemplateElements(list);
        }
        return templateVo;
    }
}

