/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.utils.contracttemplate;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplate.ContractTemplateDto;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplateelement.ContractTemplateElementDto;
import com.biz.crm.dms.business.contract.sdk.enums.ContractSignType;
import com.biz.crm.dms.business.contract.sdk.enums.ContractYearType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ContractTemplateUtil {
    public static void validateAdd(ContractTemplateDto dto) {
        Validate.notNull((Object)dto, (String)"\u5408\u540c\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getTemplateElements()), (String)"\u8981\u7d20\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTemplateName(), (String)"\u5408\u540c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getContractSignType(), (String)"\u5408\u540c\u6a21\u677f\u7b7e\u7f72\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)ContractSignType.getByKey((String)dto.getContractSignType()), (String)"\u5408\u540c\u7b7e\u7f72\u65b9\u5f0f\u4f20\u5165\u6570\u636e\u4e0d\u5339\u914d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getYearType(), (String)"\u5408\u540c\u6a21\u677f\u5e74\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)ContractYearType.getByKey((String)dto.getYearType()), (String)"\u5408\u540c\u6a21\u677f\u5e74\u5ea6\u7c7b\u578b\u4f20\u5165\u6570\u636e\u4e0d\u5339\u914d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getExpirationReminder(), (String)"\u5408\u540c\u6a21\u677f\u5230\u671f\u63d0\u9192\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (BooleanEnum.TRUE.getNumStr().equals(dto.getExpirationReminder())) {
            Validate.notNull((Object)dto.getExpirationReminderNum(), (String)"\u5408\u540c\u6a21\u677f\u5230\u671f\u63d0\u9192\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getIndexPopup(), (String)"\u9996\u9875\u662f\u5426\u5f39\u51fa\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getEffectiveDay(), (String)"\u6709\u6548\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((dto.getEffectiveDay() > 0 ? 1 : 0) != 0, (String)"\u6709\u6548\u5929\u6570\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
            if (dto.getIndexPopup().booleanValue()) {
                Validate.notBlank((CharSequence)dto.getPopupType(), (String)"\u5f39\u51fa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        } else {
            dto.setExpirationReminder(BooleanEnum.FALSE.getNumStr());
            dto.setExpirationReminderNum(null);
        }
        Validate.isTrue((dto.getTemplateName().length() <= 100 ? 1 : 0) != 0, (String)"\u5408\u540c\u6a21\u677f\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)dto.getContext())) {
            Validate.isTrue((dto.getContext().length() <= 500 ? 1 : 0) != 0, (String)"\u5408\u540c\u5230\u671f\u63d0\u793a\u8bed\u4e0d\u80fd\u8d85\u8fc7500", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getRemark())) {
            Validate.isTrue((dto.getRemark().length() <= 400 ? 1 : 0) != 0, (String)"\u5408\u540c\u6a21\u677f\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7400", (Object[])new Object[0]);
        }
        List templateElements = dto.getTemplateElements();
        templateElements.forEach(tuple -> {
            Validate.notBlank((CharSequence)tuple.getElementCode(), (String)"\u8981\u7d20\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)tuple.getIndexCode(), (String)"\u8981\u7d20\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)tuple.getElementName(), (String)"\u8981\u7d20\u5bf9\u8c61\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)tuple.getElementComponentName(), (String)"\u8981\u7d20\u7ec4\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
        Set elementCodes = templateElements.stream().map(ContractTemplateElementDto::getElementCode).collect(Collectors.toSet());
        Set indexCodes = templateElements.stream().map(ContractTemplateElementDto::getIndexCode).collect(Collectors.toSet());
        Validate.isTrue((templateElements.size() == elementCodes.size() ? 1 : 0) != 0, (String)"\u5408\u540c\u8981\u7d20\u6a21\u677f\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
        Validate.isTrue((templateElements.size() == indexCodes.size() ? 1 : 0) != 0, (String)"\u5408\u540c\u8981\u7d20\u6392\u5e8f\u91cd\u590d", (Object[])new Object[0]);
    }

    public static void validateEdit(ContractTemplateDto dto) {
        ContractTemplateUtil.validateAdd(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7f16\u8f91\u6a21\u677f\u65f6\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTemplateCode(), (String)"\u7f16\u8f91\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

