package com.biz.crm.dms.business.contract.local.context.contractelement;

import com.biz.crm.dms.business.contract.sdk.enums.ContractSignType;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import com.biz.crm.dms.business.contract.sdk.vo.contractelement.ContractElementModelVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @description: 合同要素（初始化）
 * @author: rentao
 * @date: 2021/11/16 16:17
 */
@Component
public class ContractElementContext {

  @Autowired(required = false)
  private List<ContractElementRegister> eventListeners;

  @Autowired(required = false)
  @Qualifier("contractSignBarRegister")
  private ContractElementRegister contractElementRegister;

  /**
   * 得到所有要素
   *
   * @return
   */
  public List<ContractElementModelVo> getAllConfig(String contractSignType) {
    List<ContractElementModelVo> list = new ArrayList<>();
    if (CollectionUtils.isNotEmpty(eventListeners)) {
      eventListeners.forEach(
          s -> {
            if (!ContractSignType.ELECTRONIC_SIGNATURE.getDictCode().equals(contractSignType)
                && contractElementRegister.getContractElementCode()
                .equals(s.getContractElementCode())) {
              return;
            }
            ContractElementModelVo vo = new ContractElementModelVo();
            Validate.notNull(s.getElementSort(), "合同要素模板排序不能为空");
            Validate.notBlank(s.getContractElementName(), "合同要素模板名称不能为空");
            Validate.notBlank(s.getContractElementCode(), "合同要素模板编码不能为空");
            Validate.notBlank(s.getContractElementComponentName(), "合同要素组件名称不能为空");
            vo.setElementSort(s.getElementSort());
            vo.setElementComponentName(s.getContractElementComponentName());
            vo.setElementName(s.getContractElementName());
            vo.setElementCode(s.getContractElementCode());
            vo.setRemark(s.getContractElementRemarks());
            list.add(vo);
          });
    }
    if (CollectionUtils.isNotEmpty(list)) {
      Collections.sort(
          list,
          new Comparator<ContractElementModelVo>() {
            @Override
            public int compare(ContractElementModelVo o1, ContractElementModelVo o2) {
              return o1.getElementSort().compareTo(o2.getElementSort());
            }
          });
    }
    return list;
  }
}
