package com.biz.crm.dms.business.contract.local.controller.contract;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.local.service.contract.ContractAdditionalFileService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractAdditionalFileDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 合同管理: ContractAdditionalFileVo: 合同附加文件信息
 *
 * @author ning.zhang
 * @date 2022/8/17
 */
@Slf4j
@RestController
@RequestMapping(value = {"/v1/contract/contractAdditionalFile"})
@Api(tags = "合同管理: ContractAdditionalFile: 合同附加文件信息")
public class ContractAdditionalFileController {

  @Autowired
  private ContractAdditionalFileService contractAdditionalFileService;

  /**
   * 创建合同附加文件
   *
   * @param dtoList 合同附加文件
   */
  @ApiOperation(value = "创建合同附加文件")
  @PostMapping("")
  public Result create(@RequestBody List<ContractAdditionalFileDto> dtoList) {
    this.contractAdditionalFileService.create(dtoList);
    return Result.ok();
  }
}
