package com.biz.crm.dms.business.contract.local.controller.contract;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.sdk.service.ContractAdditionalFileTypeVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractAdditionalFileTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 合同管理: ContractAdditionalFileTypeVo: 合同附加文件类型信息
 *
 * @author ning.zhang
 * @date 2022/8/17
 */
@Slf4j
@RestController
@RequestMapping(value = {"/v1/contract/ContractAdditionalFileType"})
@Api(tags = "合同管理: ContractAdditionalFileTypeVo: 合同附加文件类型信息")
public class ContractAdditionalFileTypeVoController {

  @Autowired
  private ContractAdditionalFileTypeVoService contractAdditionalFileTypeVoService;

  /**
   * 获取所有附加文件类型列表
   *
   * @return 附加文件类型列表
   */
  @ApiOperation(value = "获取所有附加文件类型列表")
  @GetMapping("/findAll")
  public Result<List<ContractAdditionalFileTypeVo>> findAll() {
    return Result.ok(this.contractAdditionalFileTypeVoService.findAll());
  }
}
