package com.biz.crm.dms.business.contract.local.controller.contract;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.sdk.service.ContractAdditionalFileVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractAdditionalFileVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 合同管理: ContractAdditionalFileVo: 合同附加文件信息
 *
 * @author ning.zhang
 * @date 2022/8/17
 */
@Slf4j
@RestController
@RequestMapping(value = {"/v1/contract/contractAdditionalFile"})
@Api(tags = "合同管理: ContractAdditionalFileVo: 合同附加文件信息")
public class ContractAdditionalFileVoController {

  @Autowired
  private ContractAdditionalFileVoService contractAdditionalFileVoService;

  /**
   * 通过合同ID获取附加文件列表
   *
   * @param contractId 合同ID
   * @return 附加文件列表
   */
  @ApiOperation(value = "通过合同ID获取附加文件列表")
  @GetMapping("/findByContractId")
  public Result<List<ContractAdditionalFileVo>> findByContractId(@RequestParam String contractId) {
    return Result.ok(this.contractAdditionalFileVoService.findByContractId(contractId));
  }
}
