package com.biz.crm.dms.business.contract.local.controller.contract;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.service.contract.ContractService;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @description: 合同
 * @author: rentao
 * @date: 2021/11/15 18:01
 */
@Api(tags = "合同管理: Contract 合同信息")
@RestController
@RequestMapping(value = {"/v1/contract/contract"})
@Slf4j
public class ContractController {

  @Autowired(required = false)
  private ContractService contractService;

  /**
   * 分页查询
   *
   * @param pageable
   * @param contractDto
   */
  @ApiOperation(value = "分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<Contract>> findByConditions(
      @PageableDefault(50) Pageable pageable, ContractDto contractDto) {
    return Result.ok(this.contractService.findByConditions(pageable, contractDto));
  }

  /**
   * 新增
   *
   * @param contractDto
   */
  @ApiOperation(value = "新增")
  @PostMapping("")
  public Result<Contract> create(@RequestBody ContractDto contractDto) {
    return Result.ok(this.contractService.create(contractDto));
  }

  /**
   * 更新
   *
   * @param contractDto
   */
  @ApiOperation(value = "更新")
  @PatchMapping("")
  public Result<Contract> update(@RequestBody ContractDto contractDto) {
    return Result.ok(this.contractService.update(contractDto));
  }

  /**
   * 启用模板
   *
   * @param ids
   */
  @ApiOperation(value = "启用模板")
  @PatchMapping("/enableBatch")
  public Result<?> enableBatch(@RequestBody List<String> ids) {
    this.contractService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  /**
   * 禁用模板
   *
   * @param ids
   */
  @ApiOperation(value = "禁用模板")
  @PatchMapping("/disableBatch")
  public Result<?> disableBatch(@RequestBody List<String> ids) {
    this.contractService.disableBatch(ids);
    return Result.ok("禁用成功");
  }

  /**
   * 合同签署
   *
   * @param contractCode
   */
  @ApiOperation(value = "合同签署")
  @PatchMapping("/signContract")
  public Result<?> signContract(@RequestParam String contractCode) {
    this.contractService.signContract(contractCode);
    return Result.ok("签署成功");
  }


  /**
   * 合同签署
   *
   * @param contractCode
   */
  @ApiOperation(value = "合同签署")
  @PostMapping("/signContractTurnPatch")
  public Result<?> signContractTurnPatch(@RequestParam String contractCode) {
    this.contractService.signContract(contractCode);
    return Result.ok("签署成功");
  }

  /**
   * 合同作废
   *
   * @param contractCode
   */
  @ApiOperation(value = "合同作废")
  @PatchMapping("/cancellation")
  public Result<?> cancellation(@RequestParam String contractCode) {
    this.contractService.cancellation(contractCode);
    return Result.ok("作废成功");
  }

  /**
   * 合同推送
   *
   * @param contractCode
   */
  @ApiOperation(value = "合同推送")
  @PatchMapping("/handlePush")
  public Result<?> handlePush(@RequestParam String contractCode) {
    this.contractService.handlePush(contractCode);
    return Result.ok("合同推送");
  }

}
