package com.biz.crm.dms.business.contract.local.controller.contract;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractCustomerDto;
import com.biz.crm.dms.business.contract.sdk.service.ContractVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @description: 合同vo
 * @author: rentao
 * @date: 2021/11/15 18:01
 */
@Slf4j
@Api(tags = "合同管理: ContractVo 合同信息")
@RestController
@RequestMapping(value = {"/v1/contract/contract"})
public class ContractVoController {

  @Autowired(required = false)
  private ContractVoService contractVoService;

  /**
   * 根据主键id查询
   *
   * @param id
   */
  @ApiOperation(value = "根据主键id查询")
  @GetMapping("/findById")
  public Result<ContractVo> findById(@RequestParam String id) {
    ContractVo result = this.contractVoService.findById(id);
    return Result.ok(result);
  }

  /**
   * 根据合同编码查询
   *
   * @param contractCode
   */
  @ApiOperation(value = "根据合同编码查询")
  @GetMapping("/findDetailsByCode")
  public Result<ContractVo> findDetailsByCode(@RequestParam String contractCode) {
    ContractVo result = this.contractVoService.findDetailsByCode(contractCode);
    return Result.ok(result);
  }

  /**
   * 客户-合同分页查询
   *
   * @param pageable
   * @param contractCustomerDto
   * @return
   */
  @ApiOperation(value = "客户-合同分页查询")
  @GetMapping("/findByContractCustomerDto")
  public Result<Page<ContractVo>> findByContractCustomerDto(@PageableDefault(50) Pageable pageable ,
                                                            @ApiParam(name = "ContractCustomerDto", value = "分页Dto") ContractCustomerDto contractCustomerDto) {
    try {
      return Result.ok(this.contractVoService.findByContractCustomerDto(pageable, contractCustomerDto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-待签署合同数量
   *
   * @param contractCustomerDto
   * @return
   */
  @ApiOperation(value = "客户-待签署合同数量")
  @GetMapping("/findUnsignedCountByCurrentCustomer")
  public Result<Integer> findUnsignedCountByCurrentCustomer(ContractCustomerDto contractCustomerDto) {
    try {
      Integer count = this.contractVoService.findUnsignedCountByCurrentCustomer(contractCustomerDto);
      return Result.ok(count);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据经销商编码查询生效的合同集合
   *
   * @param customerCode
   * @return
   */
  @ApiOperation(value = "根据经销商编码查询生效的合同集合")
  @GetMapping("/findEffectiveByCustomerCode")
  public Result<List<ContractVo>> findEffectiveByCustomerCode(@ApiParam(name = "customerCode", value = "客户编码") String customerCode) {
    try {
      return Result.ok(this.contractVoService.findEffectiveByCustomerCode(customerCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
