package com.biz.crm.dms.business.contract.local.controller.contractelement;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.local.service.contractelement.ContractElementModelVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contractelement.ContractElementModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @description: 合同要素
 * @author: rentao
 * @date: 2021/11/15 18:01
 */
@Api(tags = "合同要素模板")
@RestController
@RequestMapping(value = {"/v1/contractElement/contractElement"})
public class ContractElementModelVoController {

  @Autowired(required = false) private ContractElementModelVoService contractElementModelVoService;

  /**
   * 合同要素列表
   *
   * @param contractSignType
   */
  @ApiOperation(value = "合同要素模板列表")
  @GetMapping("/findByConditions")
  public Result<List<ContractElementModelVo>> findByConditions(
      @RequestParam String contractSignType) {
    return Result.ok(this.contractElementModelVoService.findByConditions(contractSignType));
  }
}
