package com.biz.crm.dms.business.contract.local.controller.contractelement;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.local.service.contractelement.ContractElementService;
import com.biz.crm.dms.business.contract.sdk.service.ContractVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 合同要素vo
 * @author: rentao
 * @date: 2021/11/15 18:01
 */
@Slf4j
@Api(tags = "合同要素: ContractElementVo 合同要素")
@RestController
@RequestMapping(value = {"/v1/contractelement/contractelement"})
public class ContractElementVoController {

  @Autowired(required = false)
  private ContractElementService contractElementService;

  /**
   * 查询要素内容
   * 此接口就是合同主动调用时展示的要素内容接口 例如（今麦郎）合同中主动取查询销量目标展示等
   * @param contractVo
   * @return
   */
  @ApiOperation(value = "查询要素内容（主动调用）")
  @GetMapping("/findInitiativeContractElement")
  public Result<Map<String, JSONObject>> findInitiativeContractElement(ContractVo contractVo) {
    try {
      Map<String, JSONObject> contractElement = this.contractElementService
          .findInitiativeContractElement(contractVo);
      return Result.ok(contractElement);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
