package com.biz.crm.dms.business.contract.local.controller.contracttemplate;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.local.entity.contracttemplate.ContractTemplate;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateService;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplate.ContractTemplateDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @description: 合同模板
 * @author: rentao
 * @date: 2021/11/15 18:00
 */
@Api(tags = "合同模板: ContractTemplate 合同模板")
@RestController
@RequestMapping(value = {"/v1/contractTemplate/contractTemplate"})
public class ContractTemplateController {

  @Autowired(required = false) private ContractTemplateService contractTemplateService;

  /**
   * 分页查询
   *
   * @param pageable
   * @param dto
   */
  @ApiOperation(value = "分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<ContractTemplate>> findByConditions(
      @PageableDefault(50) Pageable pageable, ContractTemplateDto dto) {
    return Result.ok(this.contractTemplateService.findByConditions(pageable, dto));
  }

  /**
   * 新增
   *
   * @param dto
   */
  @ApiOperation(value = "新增")
  @PostMapping("")
  public Result<ContractTemplate> create(@RequestBody ContractTemplateDto dto) {
    return Result.ok(this.contractTemplateService.create(dto));
  }

  /**
   * 更新
   *
   * @param dto
   */
  @ApiOperation(value = "更新")
  @PatchMapping("")
  public Result<ContractTemplate> update(@RequestBody ContractTemplateDto dto) {
    return Result.ok(this.contractTemplateService.update(dto));
  }

  /**
   * 启用模板
   *
   * @param ids
   */
  @ApiOperation(value = "启用模板")
  @PatchMapping("/enableBatch")
  public Result<?> enableBatch(@RequestBody List<String> ids) {
    this.contractTemplateService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  /**
   * 删除模板
   *
   * @param ids
   */
  @ApiOperation(value = "删除模板")
  @PatchMapping("/deleteBatch")
  public Result<?> deleteBatch(@RequestBody List<String> ids) {
    this.contractTemplateService.deleteBatch(ids);
    return Result.ok("删除成功");
  }

  /**
   * 禁用模板
   *
   * @param ids
   */
  @ApiOperation(value = "禁用模板")
  @PatchMapping("/disableBatch")
  public Result<?> disableBatch(@RequestBody List<String> ids) {
    this.contractTemplateService.disableBatch(ids);
    return Result.ok("禁用成功");
  }
}
