package com.biz.crm.dms.business.contract.local.controller.contracttemplate;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.contract.local.service.contracttemplate.ContractTemplateVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplate.ContractTemplateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 合同模板vo
 * @author: rentao
 * @date: 2021/11/23 17:47
 */
@Api(tags = "合同模板: ContractTemplateVo 合同模板")
@RestController
@RequestMapping(value = {"/v1/contractTemplate/contractTemplate"})
public class ContractTemplateVoController {

  @Autowired(required = false) private ContractTemplateVoService contractTemplateVoService;

  /**
   * 根据主键id查询
   *
   * @param id
   */
  @ApiOperation(value = "根据主键id查询")
  @GetMapping("/findById")
  public Result<ContractTemplateVo> findById(@RequestParam String id) {
    ContractTemplateVo result = this.contractTemplateVoService.findById(id);
    return Result.ok(result);
  }

  /**
   * 根据模板编码查询
   *
   * @param templateCode
   */
  @ApiOperation(value = "根据模板编码查询")
  @GetMapping("/findDetailsByCode")
  public Result<ContractTemplateVo> findDetailsByCode(@RequestParam String templateCode) {
    ContractTemplateVo result = this.contractTemplateVoService.findDetailsByCode(templateCode);
    return Result.ok(result);
  }
}
