package com.biz.crm.dms.business.contract.local.entity.contract;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Index;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: 合同
 * @author: rentao
 * @date: 2021/11/15 15:42
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractEntity", description = "合同")
@Entity
@TableName("dms_contract")
@Table(
    name = "dms_contract",
    indexes = {@Index(columnList = "tenant_code , contract_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_contract", comment = "合同")
public class Contract extends TenantFlagOpEntity {

  private static final long serialVersionUID = -2907621585607605964L;

  /**
   * 合同编码
   */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(
      name = "contract_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '合同编码'")
  private String contractCode;

  /**
   * 合同名称
   */
  @ApiModelProperty(name = "contractName", value = "合同名称", required = true)
  @Column(
      name = "contract_name",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '合同名称'")
  private String contractName;

  /**
   * 模板编码
   */
  @ApiModelProperty(name = "templateCode", value = "模板编码", required = true)
  @Column(
      name = "template_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '模板编码'")
  private String templateCode;

  /**
   * 合同类型
   */
  @ApiModelProperty(name = "contractType", value = "合同类型", required = true)
  @Column(
      name = "contract_type",
      length = 10,
      columnDefinition = "VARCHAR(10) NOT NULL COMMENT '合同类型'")
  private String contractType;

  /**
   * 合同年度
   */
  @ApiModelProperty(name = "contractYear", value = "合同年度", required = true)
  @Column(
      name = "contract_year",
      length = 4,
      columnDefinition = "VARCHAR(4) NOT NULL COMMENT '合同年度'")
  private String contractYear;

  /**
   * 年度类型
   */
  @ApiModelProperty(name = "yearType", value = "年度类型", required = true)
  @Column(name = "year_type", length = 4, columnDefinition = "VARCHAR(4) NOT NULL COMMENT '年度类型'")
  private String yearType;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  @Column(
      name = "cus_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '客户编码'")
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "cusName", value = "客户名称", required = true)
  @Column(
      name = "cus_name",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '客户名称'")
  private String cusName;

  /**
   * 渠道类型
   */
  @ApiModelProperty(name = "channelCode", value = "渠道编码", required = true)
  @Column(name = "channel_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '渠道编码'")
  private String channelCode;

  /**
   * 渠道名称
   */
  @ApiModelProperty(name = "channelName", value = "渠道名称", required = true)
  @Column(name = "channel_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '渠道名称'")
  private String channelName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty(name = "orgCode", value = "所属组织编码", required = true)
  @Column(name = "org_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属组织编码'")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty(name = "orgName", value = "所属组织名称", required = true)
  @Column(name = "org_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '所属组织名称'")
  private String orgName;

  /**
   * 合同开始时间
   */
  @ApiModelProperty(name = "startTime", value = "合同开始时间", required = true)
  @Column(
      name = "start_time",
      length = 20,
      columnDefinition = "VARCHAR(20) NOT NULL COMMENT '合同开始时间'")
  private String startTime;

  /**
   * 合同结束时间
   */
  @ApiModelProperty(name = "endTime", value = "合同结束时间", required = true)
  @Column(
      name = "end_time",
      length = 20,
      columnDefinition = "VARCHAR(20) NOT NULL COMMENT '合同结束时间'")
  private String endTime;

  /**
   * 对接人
   */
  @ApiModelProperty(name = "dockingPeople", value = "对接人", required = true)
  @Column(name = "docking_people", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '对接人'")
  private String dockingPeople;

  /**
   * 客户法律代表
   */
  @ApiModelProperty(name = "cusLegalRepresentative", value = "客户法律代表", required = true)
  @Column(
      name = "cus_legal_representative",
      length = 128,
      columnDefinition = "VARCHAR(128)  COMMENT '客户法律代表'")
  private String cusLegalRepresentative;

  /**
   * 客户联系方式
   */
  @ApiModelProperty(name = "cusContactPerson", value = "客户联系人", required = true)
  @Column(name = "cus_contact_person", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户联系方式'")
  private String cusContactPerson;

  /**
   * 客户联系方式
   */
  @ApiModelProperty(name = "cusContact", value = "客户联系方式", required = true)
  @Column(name = "cus_contact", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户联系方式'")
  private String cusContact;

  /**
   * 客户统一信用证代码
   */
  @ApiModelProperty(name = "cus_social_confidence_code", value = "客户统一信用证代码", required = true)
  @Column(name = "cus_social_confidence_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户统一信用证代码'")
  private String cusSocialConfidenceCode;

  /**
   * 客户地址
   */
  @ApiModelProperty(name = "cusAddress", value = "客户地址", required = true)
  @Column(name = "cus_address", columnDefinition = "VARCHAR(255)  COMMENT '客户地址'")
  private String cusAddress;

  /**
   * 客户开户行
   */
  @ApiModelProperty(name = "cusOpenBank", value = "客户开户行", required = true)
  @Column(name = "cus_open_bank", columnDefinition = "VARCHAR(255)  COMMENT '客户开户行'")
  private String cusOpenBank;

  /**
   * 客户开户账号
   */
  @ApiModelProperty(name = "cusOpenBankNo", value = "客户开户账号", required = true)
  @Column(name = "cus_open_bank_no", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户开户账号'")
  private String cusOpenBankNo;

  /**
   * 甲方统一信用证代码
   */
  @ApiModelProperty(name = "fp_social_confidence_code", value = "甲方统一信用证代码", required = true)
  @Column(name = "fp_social_confidence_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '甲方统一信用证代码'")
  private String fpSocialConfidenceCode;

  /**
   * 甲方地址
   */
  @ApiModelProperty(name = "fpAddress", value = "甲方地址", required = true)
  @Column(name = "fp_address", columnDefinition = "VARCHAR(255)  COMMENT '甲方地址'")
  private String fpAddress;

  /**
   * 甲方开户行
   */
  @ApiModelProperty(name = "fpOpenBank", value = "甲方开户行", required = true)
  @Column(name = "fp_open_bank", columnDefinition = "VARCHAR(255)  COMMENT '甲方开户行'")
  private String fpOpenBank;

  /**
   * 甲方开户账号
   */
  @ApiModelProperty(name = "fpOpenBankNo", value = "甲方开户账号", required = true)
  @Column(name = "fp_open_bank_no", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '甲方开户账号'")
  private String fpOpenBankNo;

  /**
   * 甲方公司名称
   */
  @ApiModelProperty(name = "fpCompanyName", value = "甲方公司名称", required = true)
  @Column(name = "fp_company_name", columnDefinition = "VARCHAR(255)  COMMENT '甲方公司名称'")
  private String fpCompanyName;

  /**
   * 甲方客服电话
   */
  @ApiModelProperty(name = "fpServiceTel", value = "甲方客服电话", required = true)
  @Column(name = "fp_service_tel", length = 64, columnDefinition = "VARCHAR(64)  COMMENT '甲方客服电话'")
  private String fpServiceTel;

  /**
   * 省编码
   */
  @ApiModelProperty(name = "provinceCode", value = "省编码", required = true)
  @Column(name = "province_code", length = 64, columnDefinition = "VARCHAR(64)  COMMENT '省编码'")
  private String provinceCode;

  /**
   * 省
   */
  @ApiModelProperty(name = "province", value = "省", required = true)
  @Column(name = "province", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '省'")
  private String province;

  /**
   * 市编码
   */
  @ApiModelProperty(name = "cityCode", value = "市编码", required = true)
  @Column(name = "city_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '市编码'")
  private String cityCode;

  /**
   * 市
   */
  @ApiModelProperty(name = "city", value = "市", required = true)
  @Column(name = "city", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '市'")
  private String city;

  /**
   * 区县编码
   */
  @ApiModelProperty(name = "districtCode", value = "区县编码", required = true)
  @Column(name = "district_code", length = 64, columnDefinition = "VARCHAR(64)  COMMENT '区县编码'")
  private String districtCode;

  /**
   * 区县
   */
  @ApiModelProperty(name = "district", value = "区县", required = true)
  @Column(name = "district", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '区县'")
  private String district;

  /**
   * 到期提醒
   */
  @ApiModelProperty(name = "expirationReminder", value = "到期提醒", required = true)
  @Column(
      name = "expiration_reminder",
      length = 10,
      columnDefinition = "VARCHAR(10)  COMMENT '到期提醒'")
  private String expirationReminder;

  /**
   * 到期提醒天数
   */
  @ApiModelProperty(name = "expirationReminderNum", value = "到期提醒天数", required = true)
  @Column(
      name = "expiration_reminder_num",
      length = 10,
      columnDefinition = "int(10)  COMMENT '到期提醒天数'")
  private Integer expirationReminderNum;

  /**
   * 到期提醒日期
   */
  @ApiModelProperty(name = "expirationReminderDate", value = "到期提醒日期", required = true)
  @Column(
      name = "expiration_reminder_date",
      length = 10,
      columnDefinition = "VARCHAR(10)  COMMENT '到期提醒日期'")
  private String expirationReminderDate;

  /**
   * 合同签署方式
   */
  @ApiModelProperty(name = "contractSignType", value = "合同签署方式", required = true)
  @Column(
      name = "contract_sign_type",
      length = 10,
      columnDefinition = "VARCHAR(10) NOT NULL COMMENT '合同签署方式'")
  private String contractSignType;

  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  @Column(name = "registered_address", columnDefinition = "VARCHAR(500) COMMENT '注册地址'")
  private String registeredAddress;


  /**
   * 审批流程编码
   */
  @ApiModelProperty("审批流程编码")
  @Column(name = "process_Key", columnDefinition = "VARCHAR(64) COMMENT '审批流程编码'")
  private String processKey;

  /**
   * 审批单号
   */
  @ApiModelProperty("审批单号")
  @Column(name = "process_number", columnDefinition = "varchar(64) COMMENT '审批单号'")
  private String processNumber;

  /**
   * 审批备注
   */
  @ApiModelProperty("审批备注")
  @Column(name = "process_remark", columnDefinition = "varchar(200) COMMENT '审批备注'")
  private String processRemark;

  /**
   * 是否作废
   */
  @ApiModelProperty(name = "cancellationState", value = "是否作废 0否1是", required = true)
  @Column(
      name = "cancellation_state",
      nullable = false,
      columnDefinition = "smallint COMMENT '是否作废 0否1是'")
  private Integer cancellationState;

  /**
   * 合同状态
   */
  @ApiModelProperty("合同状态")
  @Column(name = "contract_status", columnDefinition = "varchar(32) COMMENT '合同状态'")
  private String contractStatus;

  /**
   * 生效状态
   */
  @ApiModelProperty("生效状态")
  @Column(name = "effective_status", columnDefinition = "varchar(32) COMMENT '生效状态'")
  private String effectiveStatus;

  /**
   * 文件pdf唯一标识
   */
  @ApiModelProperty("文件pdf唯一标识")
  @Column(name = "failed_file_code", columnDefinition = "varchar(128) COMMENT '文件pdf唯一标识'")
  private String failedFileCode;

}
