package com.biz.crm.dms.business.contract.local.entity.contract;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 合同附加文件实体类
 *
 * @author ning.zhang
 * @date 2022/8/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractAdditionalFile", description = "合同附加文件实体类")
@Entity
@TableName("dms_contract_additional_file")
@Table(name = "dms_contract_additional_file",indexes = {
    @Index(name = "dms_contract_additional_file_index1", columnList = "contract_id"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_contract_additional_file", comment = "合同附加文件表")
public class ContractAdditionalFile extends FileEntity {

  private static final long serialVersionUID = -3142427428283202879L;

  /**
   * 合同ID
   */
  @ApiModelProperty(value = "合同ID")
  @Column(name = "contract_id",length = 64,columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同ID'")
  private String contractId;

  /**
   * 文件类型key
   */
  @ApiModelProperty("文件类型")
  @Column(name = "file_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '文件类型key(不同附加文件实现模块的key值)'")
  private String fileType;

  /**
   * 附加文件编码
   */
  @ApiModelProperty(value = "附加文件编码")
  @Column(name = "additional_file_code",length = 64,columnDefinition = "VARCHAR(64) NOT NULL COMMENT '附加文件编码'")
  private String additionalFileCode;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  @Column(name = "sort_index", length = 4, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
  private Integer sortIndex;

  /**
   * 附加类型key(不同附加文件实现模块的key值)
   */
  @ApiModelProperty("附加类型key(不同附加文件实现模块的key值)")
  @Column(name = "additional_type_key", length = 32, columnDefinition = "VARCHAR(32) COMMENT '附加类型key(不同附加文件实现模块的key值)'")
  private String additionalTypeKey;
}
