package com.biz.crm.dms.business.contract.local.entity.contractaddresscontact;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 合同地址联系人实体类
 *
 * @author ning.zhang
 * @date 2022/8/15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractAddressContact", description = "合同地址联系人实体类")
@Entity
@TableName("dms_contract_address_contact")
@Table(name = "dms_contract_address_contact")
@org.hibernate.annotations.Table(appliesTo = "dms_contract_address_contact", comment = "合同地址联系人表")
public class ContractAddressContact extends UuidFlagOpEntity {

  private static final long serialVersionUID = 465538261289848128L;

  /**
   * 合同编码
   */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(name = "contract_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同编码'")
  private String contractCode;


  /**
   * 供方法定地址
   */
  @ApiModelProperty("供方法定地址")
  @Column(name = "supplier_legal_address", columnDefinition = "varchar(255) COMMENT '供方法定地址'")
  private String supplierLegalAddress;

  /**
   * 供方联系人
   */
  @ApiModelProperty("供方联系人")
  @Column(name = "supplier_contact", length = 64, columnDefinition = "varchar(64) COMMENT '供方联系人'")
  private String supplierContact;

  /**
   * 供方电话
   */
  @ApiModelProperty("供方电话")
  @Column(name = "supplier_phone", length = 32, columnDefinition = "varchar(32) COMMENT '供方电话'")
  private String supplierPhone;

  /**
   * 供方邮箱
   */
  @ApiModelProperty("供方邮箱")
  @Column(name = "supplier_email", length = 32, columnDefinition = "varchar(32) COMMENT '供方邮箱'")
  private String supplierEmail;

  /**
   * 供方传真
   */
  @ApiModelProperty("供方传真")
  @Column(name = "supplier_fax", length = 32, columnDefinition = "varchar(32) COMMENT '供方传真'")
  private String supplierFax;

  /**
   * 需方法定地址
   */
  @ApiModelProperty("需方法定地址")
  @Column(name = "buyer_legal_address", columnDefinition = "varchar(255) COMMENT '需方法定地址'")
  private String buyerLegalAddress;

  /**
   * 需方联系人
   */
  @ApiModelProperty("需方联系人")
  @Column(name = "buyer_contact", length = 64, columnDefinition = "varchar(64) COMMENT '需方联系人'")
  private String buyerContact;

  /**
   * 需方电话
   */
  @ApiModelProperty("需方电话")
  @Column(name = "buyer_phone", length = 32, columnDefinition = "varchar(32) COMMENT '需方电话'")
  private String buyerPhone;

  /**
   * 需方邮箱
   */
  @ApiModelProperty("需方邮箱")
  @Column(name = "buyer_email", length = 32, columnDefinition = "varchar(32) COMMENT '需方邮箱'")
  private String buyerEmail;

  /**
   * 需方传真
   */
  @ApiModelProperty("需方传真")
  @Column(name = "buyer_fax", length = 32, columnDefinition = "varchar(32) COMMENT '需方传真'")
  private String buyerFax;
}
