package com.biz.crm.dms.business.contract.local.entity.contractarea;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: 合同销售区域
 * @author: rentao
 * @date: 2021/12/17 16:23
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractAreaEntity", description = "合同销售区域")
@Entity
@TableName("dms_contract_area")
@Table(name = "dms_contract_area")
@org.hibernate.annotations.Table(appliesTo = "dms_contract_area", comment = "合同销售区域")
public class ContractArea extends UuidFlagOpEntity {
  private static final long serialVersionUID = 8382252416222138368L;

  /** 合同编码 */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(
      name = "contract_code",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同编码'")
  private String contractCode;

  /** 省编码 */
  @ApiModelProperty("省编码")
  @Column(
      name = "province_code",
      length = 64,
      columnDefinition = "varchar(64) not null COMMENT '省编码'")
  private String provinceCode;

  /** 市编码 */
  @ApiModelProperty("市编码")
  @Column(name = "city_code", length = 64, columnDefinition = "varchar(64) COMMENT '市编码'")
  private String cityCode;

  /** 区编码 */
  @ApiModelProperty("区编码")
  @Column(name = "district_code", length = 64, columnDefinition = "varchar(64) COMMENT '区编码'")
  private String districtCode;

  /** 省名称 */
  @ApiModelProperty("省名称")
  @Column(name = "province_name", columnDefinition = "varchar(255) COMMENT '区编码'")
  private String provinceName;

  /** 市名称 */
  @ApiModelProperty("市名称")
  @Column(name = "city_name", columnDefinition = "varchar(255) COMMENT '区编码'")
  private String cityName;

  /** 区名称 */
  @ApiModelProperty("区名称")
  @Column(name = "district_name", columnDefinition = "varchar(255) COMMENT '区编码'")
  private String districtName;
}
