package com.biz.crm.dms.business.contract.local.entity.contractdetailselement;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2021/11/22 15:33
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractDetailsElementEntity", description = "合同细则要素")
@Entity
@TableName("dms_contract_details_element")
@Table(name = "dms_contract_details_element")
@org.hibernate.annotations.Table(appliesTo = "dms_contract_details_element", comment = "合同细则要素")
public class ContractDetailsElement extends UuidOpEntity {
  private static final long serialVersionUID = -353908762688357868L;

  /** 合同编码 */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(
      name = "contract_code",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同编码'")
  private String contractCode;

  /** 合同细则 */
  @ApiModelProperty(name = "contractDetails", value = "合同细则", required = true)
  @Column(
      name = "contract_details",
      columnDefinition = "text NOT NULL COMMENT '合同细则'")
  private String contractDetails;
}
