package com.biz.crm.dms.business.contract.local.entity.contractfiles;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: 合同附件
 * @author: rentao
 * @date: 2021/11/17 18:03
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractFilesEntity", description = "合同附件")
@Entity
@TableName("dms_contract_files")
@Table(name = "dms_contract_files")
@org.hibernate.annotations.Table(appliesTo = "dms_contract_files", comment = "合同附件")
public class ContractFiles extends UuidFlagOpEntity {
  private static final long serialVersionUID = 8382252416222138368L;

  /** 合同编码 */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(
      name = "contract_code",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同编码'")
  private String contractCode;

  /**
   * 文件唯一识别号
   */
  @ApiModelProperty(value = "文件唯一识别号")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
  private String fileCode;

  /**
   * 原始文件名
   */
  @ApiModelProperty(name="originalFileName" , value="原始文件名")
  @TableField(value = "original_name")
  @Column(name = "original_name", nullable = true, columnDefinition = "varchar(255) COMMENT '原始文件名'")
  private String originalFileName;

}
