package com.biz.crm.dms.business.contract.local.entity.contractfreight;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 合同运费实体类
 *
 * @author ning.zhang
 * @date 2022/8/15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractFreight", description = "合同运费实体类")
@Entity
@TableName("dms_contract_freight")
@Table(name = "dms_contract_freight")
@org.hibernate.annotations.Table(appliesTo = "dms_contract_freight", comment = "合同运费表")
public class ContractFreight extends UuidFlagOpEntity {

  private static final long serialVersionUID = -1539395351337062844L;

  /**
   * 合同编码
   */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(name = "contract_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同编码'")
  private String contractCode;


  /**
   * 配送方式
   */
  @ApiModelProperty("配送方式")
  @Column(name = "distribution_type", length = 32, columnDefinition = "varchar(32) COMMENT '配送方式'")
  private String distributionType;

  /**
   * 结算方式
   */
  @ApiModelProperty("结算方式")
  @Column(name = "settlement_type", length = 32, columnDefinition = "varchar(32) COMMENT '结算方式'")
  private String settlementType;

  /**
   * 运费金额
   */
  @ApiModelProperty("运费金额")
  @Column(name = "freightAmount", columnDefinition = "DECIMAL(20,4) COMMENT '运费金额'")
  private BigDecimal freightAmount;
}
