package com.biz.crm.dms.business.contract.local.entity.contracthtml;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2022/5/18 11:32
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractHtmlEntity", description = "合同Html")
@Entity
@TableName("dms_contract_html")
@Table(
    name = "dms_contract_html",
    indexes = {@Index(columnList = "contract_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_contract_html", comment = "合同Html")
public class ContractHtmlEntity extends UuidEntity {

  @ApiModelProperty(name = "contractCode", value = "合同html", required = true)
  @Column(
      name = "html_str",
      columnDefinition = "text NOT NULL COMMENT '合同html'")
  private String htmlStr;

  /**
   * 合同编码
   */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(
      name = "contract_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '合同编码'")
  private String contractCode;

}
