package com.biz.crm.dms.business.contract.local.entity.contractliability;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: 合同违约责任
 * @author: rentao
 * @date: 2021/11/22 16:12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractLiabilityEntity", description = "合同违约责任")
@Entity
@TableName("dms_contract_liability")
@Table(name = "dms_contract_liability")
@org.hibernate.annotations.Table(appliesTo = "dms_contract_liability", comment = "合同违约责任")
public class ContractLiability extends UuidOpEntity {

  private static final long serialVersionUID = -2898928273928064486L;

  /** 合同编码 */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(
      name = "contract_code",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同编码'")
  private String contractCode;

  /** 合同责任 */
  @ApiModelProperty(name = "contractLiability", value = "合同责任", required = true)
  @Column(
      name = "contract_liability",
      columnDefinition = "text NOT NULL COMMENT '合同责任'")
  private String contractLiability;
}
