package com.biz.crm.dms.business.contract.local.entity.contractsignbar;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: 合同签署栏
 * @author: rentao
 * @date: 2021/11/24 9:51
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractSignBarEntity", description = "合同签署栏")
@Entity
@TableName("dms_contract_sign_bar")
@Table(name = "dms_contract_sign_bar")
@org.hibernate.annotations.Table(appliesTo = "dms_contract_sign_bar", comment = "合同签署栏")
public class ContractSignBar extends UuidOpEntity {
  private static final long serialVersionUID = 6334000524406113370L;

  /** 合同编码 */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  @Column(
      name = "contract_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '合同编码'")
  private String contractCode;

  /** 甲方签名 */
  @ApiModelProperty(name = "firstPartyName", value = "甲方签名", required = true)
  @Column(
      name = "first_party_name",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '甲方签名'")
  private String firstPartyName;

  /** 甲方授权代表 */
  @ApiModelProperty(name = "firstPartyAuthorized", value = "甲方授权代表", required = true)
  @Column(
      name = "first_party_authorized",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '甲方授权代表'")
  private String firstPartyAuthorized;

  /** 甲方签署日期 */
  @ApiModelProperty(name = "firstPartySignDate", value = "甲方签署日期", required = true)
  @Column(
      name = "first_party_sign_date",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '甲方签署日期'")
  private String firstPartySignDate;

  /** 乙方签名 */
  @ApiModelProperty(name = "secondPartyName", value = "乙方签名", required = true)
  @Column(
      name = "second_party_name",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '乙方签名'")
  private String secondPartyName;

  /** 乙方授权代表 */
  @ApiModelProperty(name = "secondPartyAuthorized", value = "乙方签名", required = true)
  @Column(
      name = "second_party_authorized",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '乙方授权代表'")
  private String secondPartyAuthorized;

  /** 乙方签署日期 */
  @ApiModelProperty(name = "secondPartySignDate", value = "乙方签署日期", required = true)
  @Column(
      name = "second_party_sign_date",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '乙方签署日期'")
  private String secondPartySignDate;

}
