package com.biz.crm.dms.business.contract.local.entity.contracttemplate;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Index;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: 合同模板
 * @author: rentao
 * @date: 2021/11/15 15:43
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractTemplateEntity", description = "合同模板")
@Entity
@TableName("dms_contract_template")
@Table(name = "dms_contract_template" , indexes = {@Index(columnList = "template_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_contract_template", comment = "合同模板")
public class ContractTemplate extends TenantFlagOpEntity {

  private static final long serialVersionUID = -958070147101881346L;

  /** 编码 */
  @ApiModelProperty(name = "templateCode", value = "合同模板编码", required = true)
  @Column(
      name = "template_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '编码'")
  private String templateCode;

  /** 名称 */
  @ApiModelProperty(name = "templateName", value = "合同模板名称", required = true)
  @Column(
      name = "template_name",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '名称'")
  private String templateName;

  /** 合同签署方式 */
  @ApiModelProperty(
      name = "contractSignType",
      value = "合同签署方式 '1'电子合同签署 '2'短信验证签署 '3' 线上签署",
      required = true)
  @Column(
      name = "contract_sign_type",
      length = 10,
      columnDefinition = "VARCHAR(10) NOT NULL COMMENT '合同签署方式1电子合同签署2短信验证签署3线上签署'")
  private String contractSignType;

  /** 年度类型 */
  @ApiModelProperty(name = "yearType", value = "年度类型 1 自然年 2 企业财年", required = true)
  @Column(
      name = "year_type",
      length = 10,
      columnDefinition = "VARCHAR(10) NOT NULL COMMENT '年度类型 1 自然年 2 企业财年'")
  private String yearType;

  /** 到期提醒 */
  @ApiModelProperty(name = "expirationReminder", value = "到期提醒 '0' 否 '1' 是 ", required = true)
  @Column(
      name = "expiration_reminder",
      length = 10,
      columnDefinition = "VARCHAR(10)  COMMENT '到期提醒0否1是'")
  private String expirationReminder;

  /** 到期提醒天数 */
  @ApiModelProperty(name = "expirationReminderNum", value = "到期提醒天数", required = true)
  @Column(
      name = "expiration_reminder_num",
      length = 10,
      columnDefinition = "int(10)  COMMENT '到期提醒天数'")
  private Integer expirationReminderNum;

  /** 合同到期提示 */
  @ApiModelProperty(name = "context", value = "合同到期提示", required = true)
  @Column(name = "context", length = 500, columnDefinition = "VARCHAR(500)  COMMENT '合同到期提示'")
  private String context;

  /** 组织编码 */
  @ApiModelProperty(name = "orgCode", value = "组织编码", required = true)
  @Column(name = "org_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '组织编码'")
  private String orgCode;

  /** 组织名称 */
  @ApiModelProperty(name = "orgName", value = "组织名称", required = true)
  @Column(name = "org_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '组织名称'")
  private String orgName;

  /**
   * 首页是否弹出
   */
  @ApiModelProperty("首页是否弹出")
  @Column(name = "index_popup", columnDefinition = "int(1) COMMENT '首页是否弹出,1是0否'")
  private Boolean indexPopup;

  /**
   * 弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)
   */
  @ApiModelProperty("弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)")
  @Column(name = "popup_type", length = 30, columnDefinition = "VARCHAR(30) COMMENT '弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)'")
  private String popupType;

  /**
   * 有效天数
   */
  @ApiModelProperty("有效天数")
  @Column(name = "effective_day", columnDefinition = "int(5) COMMENT '有效天数'")
  private Integer effectiveDay;

}
