package com.biz.crm.dms.business.contract.local.entity.contracttemplateelement;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: 合同模板要素模型映射表
 * @author: rentao
 * @date: 2021/11/18 14:19
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractTemplateElementEntity", description = "合同模板要素模型映射表")
@Entity
@TableName("dms_contract_template_element")
@Table(name = "dms_contract_template_element")
@org.hibernate.annotations.Table(
    appliesTo = "dms_contract_template_element",
    comment = "合同模板要素模型映射表")
public class ContractTemplateElement extends UuidFlagOpEntity {

  private static final long serialVersionUID = 2844154243437158771L;

  /** 合同模板编码 */
  @ApiModelProperty(name = "templateCode", value = "合同模板编码", required = true)
  @Column(
      name = "template_code",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同模板编码'")
  private String templateCode;

  /** 合同要素编码 */
  @ApiModelProperty(name = "elementCode", value = "合同要素编码", required = true)
  @Column(
      name = "element_code",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '合同要素编码'")
  private String elementCode;

  /** 合同要素编码 */
  @ApiModelProperty(name = "elementName", value = "合同要素名称", required = true)
  @Column(
      name = "element_name",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '合同要素名称'")
  private String elementName;

  /** 要素类要素组件名称型 */
  @ApiModelProperty(name = "elementComponentName", value = "要素组件名称", required = true)
  @Column(
      name = "element_component_name",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '要素组件名称'")
  private String elementComponentName;

  /** 数据检索编码 */
  @ApiModelProperty(name = "elementIndex", value = "数据检索编码", required = true)
  @Column(name = "element_index", length = 10, columnDefinition = "VARCHAR(10)  COMMENT '数据检索编码'")
  private String elementIndex;

  /** 要素在模板中展示顺序 */
  @ApiModelProperty(name = "indexCode", value = "要素在模板中展示顺序", required = true)
  @Column(name = "index_code", nullable = false, columnDefinition = "smallint COMMENT '要素在模板中展示顺序'")
  private Integer indexCode;
}
