package com.biz.crm.dms.business.contract.local.mapper.contract;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractCustomerDto;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractDto;
import org.apache.ibatis.annotations.Param;

/**
 * @description: 合同 的 mybatis-plus接口类
 * @author: rentao
 * @date: 2021/11/16 13:57
 */
public interface ContractMapper extends BaseMapper<Contract> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<Contract> findByConditions(Page<Contract> page, @Param("dto") ContractDto dto);

  /**
   * 客户-合同分页查询
   *
   * @param pageable
   * @param contractCustomerDto
   * @return
   */
  Page<Contract> findByContractCustomerDto(Page<Contract> pageable, @Param("dto") ContractCustomerDto contractCustomerDto);

  /**
   * 客户-待签署合同数量
   * @param contractCustomerDto
   * @return
   */
  Integer findUnsignedCountByCurrentCustomer(@Param("dto") ContractCustomerDto contractCustomerDto);
}
