package com.biz.crm.dms.business.contract.local.repository.contract;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contract.ContractAdditionalFile;
import com.biz.crm.dms.business.contract.local.mapper.contract.ContractAdditionalFileMapper;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 合同附加文件表的数据库访问类 {@link ContractAdditionalFile}
 *
 * @author ning.zhang
 * @date 2022-08-17 11:23:53
 */
@Component
public class ContractAdditionalFileRepository extends ServiceImpl<ContractAdditionalFileMapper, ContractAdditionalFile> {

  /**
   * 通过合同ID获取附加文件列表
   *
   * @param contractId 合同ID
   * @return 附加文件列表
   */
  public List<ContractAdditionalFile> findByContractId(String contractId) {
    return this.lambdaQuery()
        .eq(ContractAdditionalFile::getContractId, contractId)
        .orderByAsc(ContractAdditionalFile::getSortIndex)
        .list();
  }

  /**
   * 通过合同ID删除附加文件
   *
   * @param contractIds 合同ID
   */
  public void deleteByContractIds(Set<String> contractIds) {
    this.lambdaUpdate()
        .in(ContractAdditionalFile::getContractId, contractIds)
        .remove();
  }
}
