package com.biz.crm.dms.business.contract.local.repository.contractaddresscontact;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contractaddresscontact.ContractAddressContact;
import com.biz.crm.dms.business.contract.local.mapper.contractaddresscontact.ContractAddressContactMapper;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 合同地址联系人表的数据库访问类 {@link ContractAddressContact}
 *
 * @author ning.zhang
 * @date 2022-08-15 14:32:06
 */
@Component
public class ContractAddressContactRepository extends ServiceImpl<ContractAddressContactMapper, ContractAddressContact> {

  /**
   * 合同编码查询合同要素信息
   *
   * @param contractCode 合同编码
   * @return 合同要素信息
   */
  public ContractAddressContact findByContractCode(String contractCode) {
    if (StringUtils.isBlank(contractCode)) {
      return null;
    }
    return this.lambdaQuery().eq(ContractAddressContact::getContractCode, contractCode).one();
  }

  /**
   * 通过合同编码删除数据
   *
   * @param contractCode 合同编码
   */
  public void deleteByContractCode(String contractCode) {
    this.lambdaUpdate().eq(ContractAddressContact::getContractCode, contractCode).remove();
  }
}
