package com.biz.crm.dms.business.contract.local.repository.contractarea;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contractarea.ContractArea;
import com.biz.crm.dms.business.contract.local.mapper.contractarea.ContractAreaMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description: 合同要素 销售区域
 * @author: rentao
 * @date: 2021/11/22 15:40
 */
@Component
public class ContractAreaRepository extends ServiceImpl<ContractAreaMapper, ContractArea> {

  /**
   * 合同编码查询合同要素 销售区域列表
   *
   * @param contractcode
   * @author rentao
   * @date
   */
  public List<ContractArea> findByContractCode(String contractcode) {
    if (StringUtils.isBlank(contractcode)) {
      return null;
    }
    return this.lambdaQuery().eq(ContractArea::getContractCode, contractcode).list();
  }

  /**
   * 通过合同编码删除销售区域
   *
   * @param contractCode 合同编码
   */
  public void deleteByContractCode(String contractCode) {
    this.lambdaUpdate().eq(ContractArea::getContractCode, contractCode).remove();
  }
}
