package com.biz.crm.dms.business.contract.local.repository.contractdetailselement;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contractdetailselement.ContractDetailsElement;
import com.biz.crm.dms.business.contract.local.mapper.contractdetailselement.ContractDetailsElementMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 合同要素 细则
 * @author: rentao
 * @date: 2021/11/22 15:40
 */
@Component
public class ContractDetailsElementRepository
    extends ServiceImpl<ContractDetailsElementMapper, ContractDetailsElement> {

  /**
   * 通过合同编码查询合同细则
   *
   * @param contractcode
   * @author rentao
   * @date
   */
  public ContractDetailsElement findByContractCode(String contractcode) {
    if (StringUtils.isBlank(contractcode)) {
      return null;
    }
    return this.lambdaQuery().eq(ContractDetailsElement::getContractCode, contractcode).one();
  }
}
