package com.biz.crm.dms.business.contract.local.repository.contractfiles;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contractfiles.ContractFiles;
import com.biz.crm.dms.business.contract.local.mapper.contractfiles.ContractFilesMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description: 合同附件 数据库访问类 {@link ContractFiles}
 * @author: rentao
 * @date: 2021/11/17 18:14
 */
@Component
public class ContractFilesRepository extends ServiceImpl<ContractFilesMapper, ContractFiles> {

  /**
   * 通过合同编码查询合同附件
   *
   * @param contractcode 合同编码
   */
  public List<ContractFiles> findByContractCode(String contractcode) {
    if (StringUtils.isBlank(contractcode)) {
      return null;
    }
    return this.lambdaQuery().eq(ContractFiles::getContractCode, contractcode).list();
  }

  /**
   * 通过合同编码删除合同附件
   *
   * @param contractCode 合同编码
   */
  public void deleteByContractCode(String contractCode) {
    this.lambdaUpdate().eq(ContractFiles::getContractCode, contractCode).remove();
  }
}
