package com.biz.crm.dms.business.contract.local.repository.contractfreight;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contractfreight.ContractFreight;
import com.biz.crm.dms.business.contract.local.mapper.contractfreight.ContractFreightMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 合同运费表的数据库访问类 {@link ContractFreight}
 *
 * @author ning.zhang
 * @date 2022-08-15 14:32:05
 */
@Component
public class ContractFreightRepository extends ServiceImpl<ContractFreightMapper, ContractFreight> {

  /**
   * 合同编码查询合同要素信息
   *
   * @param contractCode 合同编码
   * @return 合同要素信息
   */
  public ContractFreight findByContractCode(String contractCode) {
    if (StringUtils.isBlank(contractCode)) {
      return null;
    }
    return this.lambdaQuery().eq(ContractFreight::getContractCode, contractCode).one();
  }

  /**
   * 通过合同编码删除数据
   *
   * @param contractCode 合同编码
   */
  public void deleteByContractCode(String contractCode) {
    this.lambdaUpdate().eq(ContractFreight::getContractCode, contractCode).remove();
  }
}
