package com.biz.crm.dms.business.contract.local.repository.contracthtml;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.local.entity.contracthtml.ContractHtmlEntity;
import com.biz.crm.dms.business.contract.local.mapper.contracthtml.ContractHtmlMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 合同html
 * @author: rentao
 * @date: 2022/5/18 11:40
 */
@Component
public class ContractHtmlRepository  extends
    ServiceImpl<ContractHtmlMapper, ContractHtmlEntity> {

  /**
   *
   * 修改
   * @param htmlStr
   * @param contractCode
   * @author rentao
   * @date
   */
  public void updateByContractCode(
      String htmlStr, String contractCode) {
    if (StringUtils.isBlank(contractCode)) {
      return;
    }
    this.lambdaUpdate()
        .set(ContractHtmlEntity::getHtmlStr, htmlStr)
        .eq(ContractHtmlEntity::getContractCode,contractCode)
        .update();
  }


  /**
   *
   * 查询
   * @param contractCode
   * @author rentao
   * @date
   */
  public ContractHtmlEntity findByContractCode(
      String contractCode) {
    if (StringUtils.isBlank(contractCode)) {
      return null;
    }
    return  this.lambdaQuery()
        .eq(ContractHtmlEntity::getContractCode,contractCode)
        .one();
  }
}
